/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class StateStoreMetrics {
    private static final String AVG_DESCRIPTION_PREFIX = "The average ";
    private static final String MAX_DESCRIPTION_PREFIX = "The maximum ";
    private static final String LATENCY_DESCRIPTION = "latency of ";
    private static final String AVG_LATENCY_DESCRIPTION_PREFIX = "The average latency of ";
    private static final String MAX_LATENCY_DESCRIPTION_PREFIX = "The maximum latency of ";
    private static final String RATE_DESCRIPTION_PREFIX = "The average number of ";
    private static final String RATE_DESCRIPTION_SUFFIX = " per second";
    private static final String BUFFERED_RECORDS = "buffered records";
    private static final String PUT = "put";
    private static final String PUT_DESCRIPTION = "calls to put";
    private static final String PUT_RATE_DESCRIPTION = "The average number of calls to put per second";
    private static final String PUT_AVG_LATENCY_DESCRIPTION = "The average latency of calls to put";
    private static final String PUT_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to put";
    private static final String PUT_IF_ABSENT = "put-if-absent";
    private static final String PUT_IF_ABSENT_DESCRIPTION = "calls to put-if-absent";
    private static final String PUT_IF_ABSENT_RATE_DESCRIPTION = "The average number of calls to put-if-absent per second";
    private static final String PUT_IF_ABSENT_AVG_LATENCY_DESCRIPTION = "The average latency of calls to put-if-absent";
    private static final String PUT_IF_ABSENT_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to put-if-absent";
    private static final String PUT_ALL = "put-all";
    private static final String PUT_ALL_DESCRIPTION = "calls to put-all";
    private static final String PUT_ALL_RATE_DESCRIPTION = "The average number of calls to put-all per second";
    private static final String PUT_ALL_AVG_LATENCY_DESCRIPTION = "The average latency of calls to put-all";
    private static final String PUT_ALL_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to put-all";
    private static final String GET = "get";
    private static final String GET_DESCRIPTION = "calls to get";
    private static final String GET_RATE_DESCRIPTION = "The average number of calls to get per second";
    private static final String GET_AVG_LATENCY_DESCRIPTION = "The average latency of calls to get";
    private static final String GET_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to get";
    private static final String FETCH = "fetch";
    private static final String FETCH_DESCRIPTION = "calls to fetch";
    private static final String FETCH_RATE_DESCRIPTION = "The average number of calls to fetch per second";
    private static final String FETCH_AVG_LATENCY_DESCRIPTION = "The average latency of calls to fetch";
    private static final String FETCH_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to fetch";
    private static final String ALL = "all";
    private static final String ALL_DESCRIPTION = "calls to all";
    private static final String ALL_RATE_DESCRIPTION = "The average number of calls to all per second";
    private static final String ALL_AVG_LATENCY_DESCRIPTION = "The average latency of calls to all";
    private static final String ALL_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to all";
    private static final String RANGE = "range";
    private static final String RANGE_DESCRIPTION = "calls to range";
    private static final String RANGE_RATE_DESCRIPTION = "The average number of calls to range per second";
    private static final String RANGE_AVG_LATENCY_DESCRIPTION = "The average latency of calls to range";
    private static final String RANGE_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to range";
    private static final String PREFIX_SCAN = "prefix-scan";
    private static final String PREFIX_SCAN_DESCRIPTION = "calls to prefix-scan";
    private static final String PREFIX_SCAN_RATE_DESCRIPTION = "The average number of calls to prefix-scan per second";
    private static final String PREFIX_SCAN_AVG_LATENCY_DESCRIPTION = "The average latency of calls to prefix-scan";
    private static final String PREFIX_SCAN_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to prefix-scan";
    private static final String FLUSH = "flush";
    private static final String FLUSH_DESCRIPTION = "calls to flush";
    private static final String FLUSH_RATE_DESCRIPTION = "The average number of calls to flush per second";
    private static final String FLUSH_AVG_LATENCY_DESCRIPTION = "The average latency of calls to flush";
    private static final String FLUSH_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to flush";
    private static final String DELETE = "delete";
    private static final String DELETE_DESCRIPTION = "calls to delete";
    private static final String DELETE_RATE_DESCRIPTION = "The average number of calls to delete per second";
    private static final String DELETE_AVG_LATENCY_DESCRIPTION = "The average latency of calls to delete";
    private static final String DELETE_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to delete";
    private static final String REMOVE = "remove";
    private static final String REMOVE_DESCRIPTION = "calls to remove";
    private static final String REMOVE_RATE_DESCRIPTION = "The average number of calls to remove per second";
    private static final String REMOVE_AVG_LATENCY_DESCRIPTION = "The average latency of calls to remove";
    private static final String REMOVE_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to remove";
    private static final String RESTORE = "restore";
    private static final String RESTORE_DESCRIPTION = "restorations";
    private static final String RESTORE_RATE_DESCRIPTION = "The average number of restorations per second";
    private static final String RESTORE_AVG_LATENCY_DESCRIPTION = "The average latency of restorations";
    private static final String RESTORE_MAX_LATENCY_DESCRIPTION = "The maximum latency of restorations";
    private static final String SUPPRESSION_BUFFER_COUNT = "suppression-buffer-count";
    private static final String SUPPRESSION_BUFFER_COUNT_DESCRIPTION = "count of buffered records";
    private static final String SUPPRESSION_BUFFER_COUNT_AVG_DESCRIPTION = "The average count of buffered records";
    private static final String SUPPRESSION_BUFFER_COUNT_MAX_DESCRIPTION = "The maximum count of buffered records";
    private static final String SUPPRESSION_BUFFER_SIZE = "suppression-buffer-size";
    private static final String SUPPRESSION_BUFFER_SIZE_DESCRIPTION = "size of buffered records";
    private static final String SUPPRESSION_BUFFER_SIZE_AVG_DESCRIPTION = "The average size of buffered records";
    private static final String SUPPRESSION_BUFFER_SIZE_MAX_DESCRIPTION = "The maximum size of buffered records";

    private StateStoreMetrics() {
    }

    public static Sensor putSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(taskId, storeType, storeName, PUT, PUT_RATE_DESCRIPTION, PUT_AVG_LATENCY_DESCRIPTION, PUT_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor putIfAbsentSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(taskId, storeType, storeName, PUT_IF_ABSENT, PUT_IF_ABSENT_RATE_DESCRIPTION, PUT_IF_ABSENT_AVG_LATENCY_DESCRIPTION, PUT_IF_ABSENT_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor putAllSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(taskId, storeType, storeName, PUT_ALL, PUT_ALL_RATE_DESCRIPTION, PUT_ALL_AVG_LATENCY_DESCRIPTION, PUT_ALL_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor getSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(taskId, storeType, storeName, GET, GET_RATE_DESCRIPTION, GET_AVG_LATENCY_DESCRIPTION, GET_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor fetchSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(taskId, storeType, storeName, FETCH, FETCH_RATE_DESCRIPTION, FETCH_AVG_LATENCY_DESCRIPTION, FETCH_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor allSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(taskId, storeType, storeName, ALL, ALL_RATE_DESCRIPTION, ALL_AVG_LATENCY_DESCRIPTION, ALL_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor rangeSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(taskId, storeType, storeName, RANGE, RANGE_RATE_DESCRIPTION, RANGE_AVG_LATENCY_DESCRIPTION, RANGE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor prefixScanSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        Map<String, String> tagMap = streamsMetrics.storeLevelTagMap(taskId, storeType, storeName);
        Sensor sensor = streamsMetrics.storeLevelSensor(taskId, storeName, PREFIX_SCAN, Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        StreamsMetricsImpl.addInvocationRateToSensor(sensor, "stream-state-metrics", tagMap, PREFIX_SCAN, PREFIX_SCAN_RATE_DESCRIPTION);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-state-metrics", tagMap, "prefix-scan-latency", PREFIX_SCAN_AVG_LATENCY_DESCRIPTION, PREFIX_SCAN_MAX_LATENCY_DESCRIPTION);
        return sensor;
    }

    public static Sensor flushSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(taskId, storeType, storeName, FLUSH, FLUSH_RATE_DESCRIPTION, FLUSH_AVG_LATENCY_DESCRIPTION, FLUSH_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor deleteSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(taskId, storeType, storeName, DELETE, DELETE_RATE_DESCRIPTION, DELETE_AVG_LATENCY_DESCRIPTION, DELETE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor removeSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(taskId, storeType, storeName, REMOVE, REMOVE_RATE_DESCRIPTION, REMOVE_AVG_LATENCY_DESCRIPTION, REMOVE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor restoreSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(taskId, storeType, storeName, RESTORE, RESTORE_RATE_DESCRIPTION, RESTORE_AVG_LATENCY_DESCRIPTION, RESTORE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor suppressionBufferCountSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.sizeOrCountSensor(taskId, storeType, storeName, SUPPRESSION_BUFFER_COUNT, SUPPRESSION_BUFFER_COUNT_AVG_DESCRIPTION, SUPPRESSION_BUFFER_COUNT_MAX_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor suppressionBufferSizeSensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.sizeOrCountSensor(taskId, storeType, storeName, SUPPRESSION_BUFFER_SIZE, SUPPRESSION_BUFFER_SIZE_AVG_DESCRIPTION, SUPPRESSION_BUFFER_SIZE_MAX_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor e2ELatencySensor(String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.storeLevelSensor(taskId, storeName, "record-e2e-latency", Sensor.RecordingLevel.TRACE, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.storeLevelTagMap(taskId, storeType, storeName);
        StreamsMetricsImpl.addAvgAndMinAndMaxToSensor(sensor, "stream-state-metrics", tagMap, "record-e2e-latency", "The average end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node", "The minimum end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node", "The maximum end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node");
        return sensor;
    }

    private static Sensor sizeOrCountSensor(String taskId, String storeType, String storeName, String gaugeName, String descriptionOfAvg, String descriptionOfMax, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.storeLevelSensor(taskId, storeName, gaugeName, recordingLevel, new Sensor[0]);
        String group = "stream-state-metrics";
        Map<String, String> tagMap = streamsMetrics.storeLevelTagMap(taskId, storeType, storeName);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, group, tagMap, gaugeName, descriptionOfAvg, descriptionOfMax);
        return sensor;
    }

    private static Sensor throughputAndLatencySensor(String taskId, String storeType, String storeName, String operation, String descriptionOfRate, String descriptionOfAvg, String descriptionOfMax, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        String latencyMetricName = operation + "-latency";
        Map<String, String> tagMap = streamsMetrics.storeLevelTagMap(taskId, storeType, storeName);
        Sensor sensor = streamsMetrics.storeLevelSensor(taskId, storeName, operation, recordingLevel, new Sensor[0]);
        StreamsMetricsImpl.addInvocationRateToSensor(sensor, "stream-state-metrics", tagMap, operation, descriptionOfRate);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-state-metrics", tagMap, latencyMetricName, descriptionOfAvg, descriptionOfMax);
        return sensor;
    }
}

