--
-- Licensed to the Apache Software Foundation (ASF) under one or more
-- contributor license agreements.  See the NOTICE file distributed with
-- this work for additional information regarding copyright ownership.
-- The ASF licenses this file to You under the Apache License, Version 2.0
-- (the "License"); you may not use this file except in compliance with
-- the License.  You may obtain a copy of the License at
--
--    http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--
-- q97 --
with ssci as (
     select
          ss_customer_sk customer_sk,
          ss_item_sk item_sk
     from
          store_sales,
          date_dim
     where
          ss_sold_date_sk = d_date_sk
          and d_month_seq between 1212
          and 1212 + 11
     group by
          ss_customer_sk,
          ss_item_sk
),
csci as (
     select
          cs_bill_customer_sk customer_sk,
          cs_item_sk item_sk
     from
          catalog_sales,
          date_dim
     where
          cs_sold_date_sk = d_date_sk
          and d_month_seq between 1212
          and 1212 + 11
     group by
          cs_bill_customer_sk,
          cs_item_sk
)
select
     sum(
          case
               when ssci.customer_sk is not null
               and csci.customer_sk is null then 1
               else 0
          end
     ) store_only,
     sum(
          case
               when ssci.customer_sk is null
               and csci.customer_sk is not null then 1
               else 0
          end
     ) catalog_only,
     sum(
          case
               when ssci.customer_sk is not null
               and csci.customer_sk is not null then 1
               else 0
          end
     ) store_and_catalog
from
     ssci full
     outer join csci on (
          ssci.customer_sk = csci.customer_sk
          and ssci.item_sk = csci.item_sk
     )
limit
     100;
