--
-- Licensed to the Apache Software Foundation (ASF) under one or more
-- contributor license agreements.  See the NOTICE file distributed with
-- this work for additional information regarding copyright ownership.
-- The ASF licenses this file to You under the Apache License, Version 2.0
-- (the "License"); you may not use this file except in compliance with
-- the License.  You may obtain a copy of the License at
--
--    http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--

--q81.sql--

 with customer_total_return as
 (select
    cr_returning_customer_sk as ctr_customer_sk, ca_state as ctr_state,
        sum(cr_return_amt_inc_tax) as ctr_total_return
 from catalog_returns, date_dim, customer_address
 where cr_returned_date_sk = d_date_sk
   and d_year = 2000
   and cr_returning_addr_sk = ca_address_sk
 group by cr_returning_customer_sk, ca_state )
 select
    c_customer_id,c_salutation,c_first_name,c_last_name,ca_street_number,ca_street_name,
    ca_street_type,ca_suite_number,ca_city,ca_county,ca_state,ca_zip,ca_country,
    ca_gmt_offset,ca_location_type,ctr_total_return
 from customer_total_return ctr1, customer_address, customer
 where ctr1.ctr_total_return > (select avg(ctr_total_return)*1.2
 			  from customer_total_return ctr2
                  	  where ctr1.ctr_state = ctr2.ctr_state)
       and ca_address_sk = c_current_addr_sk
       and ca_state = 'GA'
       and ctr1.ctr_customer_sk = c_customer_sk
 order by c_customer_id,c_salutation,c_first_name,c_last_name,ca_street_number,ca_street_name
                   ,ca_street_type,ca_suite_number,ca_city,ca_county,ca_state,ca_zip,ca_country,ca_gmt_offset
                  ,ca_location_type,ctr_total_return
 limit 100
            
