/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import java.util.Iterator;

public class PrioritizedList {
    private final LinkedItem pointerToFirst = new LinkedItem(null, 0, null);
    private int lowestPriority = Integer.MAX_VALUE;

    public void add(Object item) {
        this.add(item, 0);
    }

    public void add(Object item, int priority) {
        LinkedItem current = this.pointerToFirst;
        while (current.next != null && priority < current.next.priority) {
            current = current.next;
        }
        current.next = new LinkedItem(item, priority, current.next);
        if (priority < this.lowestPriority) {
            this.lowestPriority = priority;
        }
    }

    public Iterator iterator() {
        return new LinkedItemIterator(this.pointerToFirst.next);
    }

    public Object firstOfLowestPriority() {
        LinkedItem current = this.pointerToFirst.next;
        while (current != null) {
            if (current.priority == this.lowestPriority) {
                return current.value;
            }
            current = current.next;
        }
        return null;
    }

    private static class LinkedItemIterator
    implements Iterator {
        private LinkedItem current;

        public LinkedItemIterator(LinkedItem current) {
            this.current = current;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public Object next() {
            Object result = this.current.value;
            this.current = this.current.next;
            return result;
        }
    }

    private static class LinkedItem {
        final Object value;
        final int priority;
        LinkedItem next;

        public LinkedItem(Object value, int priority, LinkedItem next) {
            this.value = value;
            this.priority = priority;
            this.next = next;
        }
    }
}

