/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ClassAliasingMapper
extends MapperWrapper {
    protected final Map typeToNameMap = Collections.synchronizedMap(new HashMap());
    protected final Map nameToTypeMap = Collections.synchronizedMap(new HashMap());

    public ClassAliasingMapper(ClassMapper wrapped) {
        super(wrapped);
    }

    public void addClassAlias(String name, Class type) {
        this.nameToTypeMap.put(name, type.getName());
        this.typeToNameMap.put(type.getName(), name);
    }

    public String serializedClass(Class type) {
        String name = super.serializedClass(type);
        String alias = (String)this.typeToNameMap.get(type.getName());
        if (alias != null) {
            return alias;
        }
        return name;
    }

    public Class realClass(String elementName) {
        if (elementName.equals("null")) {
            return null;
        }
        String mappedName = (String)this.nameToTypeMap.get(this.mapNameFromXML(elementName));
        if (mappedName != null) {
            elementName = mappedName;
        }
        return super.realClass(elementName);
    }
}

