/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.TableColumn;
import org.apache.log4j.chainsaw.prefs.SettingsManager;

public class LogPanelPreferenceModel
implements Serializable {
    public static final String ISO8601 = "ISO8601";
    public static final Collection DATE_FORMATS;
    private static final long serialVersionUID = 7526472295622776147L;
    private final transient PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private String dateFormatPattern = "HH:mm:ss";
    private boolean levelIcons;
    private List allColumns = new ArrayList();
    private List visibleColumns = new ArrayList();
    private List visibleColumnOrder = new ArrayList();
    private boolean detailPaneVisible = true;
    private boolean toolTips;
    private boolean thumbnailBarToolTips = true;
    private boolean scrollToBottom;
    private boolean logTreePanelVisible;
    private String loggerPrecision = "";
    private Collection hiddenLoggers = new HashSet();
    private String timeZone;
    private boolean wrapMsg = true;
    private boolean highlightSearchMatchText;
    private String hiddenExpression;
    private String alwaysDisplayExpression;
    private String clearTableExpression;
    private boolean cyclic = false;
    private boolean showMillisDeltaAsGap;
    private boolean searchResultsVisible = true;

    public List getColumns() {
        return Collections.unmodifiableList(this.allColumns);
    }

    public void setCyclic(boolean cyclic) {
        this.cyclic = cyclic;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public List getVisibleColumns() {
        return Collections.unmodifiableList(this.visibleColumns);
    }

    public void clearColumns() {
        List oldValue = this.allColumns;
        this.allColumns = new ArrayList();
        this.propertySupport.firePropertyChange("columns", oldValue, this.allColumns);
    }

    private TableColumn findColumnByHeader(List list, String header) {
        for (TableColumn c : list) {
            if (c == null || c.getHeaderValue() == null || !c.getHeaderValue().equals(header)) continue;
            return c;
        }
        return null;
    }

    public void setVisibleColumnOrder(List visibleColumnOrder) {
        this.visibleColumnOrder = visibleColumnOrder;
    }

    public List getVisibleColumnOrder() {
        return this.visibleColumnOrder;
    }

    public boolean addColumn(TableColumn column) {
        if (this.findColumnByHeader(this.allColumns, column.getHeaderValue().toString()) != null) {
            return false;
        }
        List oldValue = this.allColumns;
        this.allColumns = new ArrayList(this.allColumns);
        this.allColumns.add(column);
        this.propertySupport.firePropertyChange("columns", oldValue, this.allColumns);
        return true;
    }

    private void setColumns(List columns) {
        List oldValue = this.allColumns;
        this.allColumns = new ArrayList(columns);
        this.propertySupport.firePropertyChange("columns", oldValue, columns);
    }

    public final String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public final void setDefaultDatePatternFormat() {
        String oldVal = this.dateFormatPattern;
        this.dateFormatPattern = "HH:mm:ss";
        this.propertySupport.firePropertyChange("dateFormatPattern", oldVal, this.dateFormatPattern);
    }

    public final void setDateFormatPattern(String dateFormatPattern) {
        String oldVal = this.dateFormatPattern;
        this.dateFormatPattern = dateFormatPattern;
        this.propertySupport.firePropertyChange("dateFormatPattern", oldVal, this.dateFormatPattern);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    public void apply(LogPanelPreferenceModel model) {
        this.setCyclic(model.isCyclic());
        this.setLoggerPrecision(model.getLoggerPrecision());
        this.setDateFormatPattern(model.getDateFormatPattern());
        this.setLevelIcons(model.isLevelIcons());
        this.setWrapMessage(model.isWrapMessage());
        this.setHighlightSearchMatchText(model.isHighlightSearchMatchText());
        this.setTimeZone(model.getTimeZone());
        this.setToolTips(model.isToolTips());
        this.setThumbnailBarToolTips(model.isThumbnailBarToolTips());
        this.setScrollToBottom(model.isScrollToBottom());
        this.setDetailPaneVisible(model.isDetailPaneVisible());
        this.setLogTreePanelVisible(model.isLogTreePanelVisible());
        this.setVisibleColumnOrder(model.getVisibleColumnOrder());
        this.setSearchResultsVisible(model.isSearchResultsVisible());
        this.setColumns(model.getColumns());
        this.setVisibleColumns(model.getVisibleColumns());
        this.setHiddenLoggers(model.getHiddenLoggers());
        this.setHiddenExpression(model.getHiddenExpression());
        this.setAlwaysDisplayExpression(model.getAlwaysDisplayExpression());
        this.setShowMillisDeltaAsGap(model.isShowMillisDeltaAsGap());
        this.setClearTableExpression(model.getClearTableExpression());
    }

    public boolean isUseISO8601Format() {
        return this.getDateFormatPattern().equals(ISO8601);
    }

    public boolean isLevelIcons() {
        return this.levelIcons;
    }

    public boolean isWrapMessage() {
        return this.wrapMsg;
    }

    public boolean isHighlightSearchMatchText() {
        return this.highlightSearchMatchText;
    }

    public void setLevelIcons(boolean levelIcons) {
        this.levelIcons = levelIcons;
        this.propertySupport.firePropertyChange("levelIcons", !levelIcons, levelIcons);
    }

    public void setSearchResultsVisible(boolean searchResultsVisible) {
        boolean oldValue = this.searchResultsVisible;
        this.searchResultsVisible = searchResultsVisible;
        this.propertySupport.firePropertyChange("searchResultsVisible", oldValue, searchResultsVisible);
    }

    public boolean isSearchResultsVisible() {
        return this.searchResultsVisible;
    }

    public void setWrapMessage(boolean wrapMsg) {
        this.wrapMsg = wrapMsg;
        this.propertySupport.firePropertyChange("wrapMessage", !wrapMsg, wrapMsg);
    }

    public void setHighlightSearchMatchText(boolean highlightSearchMatchText) {
        this.highlightSearchMatchText = highlightSearchMatchText;
        this.propertySupport.firePropertyChange("highlightSearchMatchText", !highlightSearchMatchText, highlightSearchMatchText);
    }

    public void setLoggerPrecision(String loggerPrecision) {
        String oldVal = this.loggerPrecision;
        this.loggerPrecision = loggerPrecision;
        this.propertySupport.firePropertyChange("loggerPrecision", oldVal, this.loggerPrecision);
    }

    public final String getLoggerPrecision() {
        return this.loggerPrecision;
    }

    public boolean isColumnVisible(TableColumn column) {
        return this.findColumnByHeader(this.visibleColumns, column.getHeaderValue().toString()) != null;
    }

    private void setVisibleColumns(List visibleColumns) {
        ArrayList oldValue = new ArrayList();
        this.visibleColumns = new ArrayList(visibleColumns);
        this.propertySupport.firePropertyChange("visibleColumns", oldValue, this.visibleColumns);
    }

    public void setColumnVisible(String columnName, boolean isVisible) {
        boolean wasVisible = this.findColumnByHeader(this.visibleColumns, columnName) != null;
        TableColumn col = this.findColumnByHeader(this.allColumns, columnName);
        if (isVisible && !wasVisible) {
            this.visibleColumns.add(col);
            this.visibleColumnOrder.add(col);
            this.propertySupport.firePropertyChange("visibleColumns", new Boolean(isVisible), new Boolean(wasVisible));
        }
        if (!isVisible && wasVisible) {
            this.visibleColumns.remove(col);
            this.visibleColumnOrder.remove(col);
            this.propertySupport.firePropertyChange("visibleColumns", new Boolean(isVisible), new Boolean(wasVisible));
        }
    }

    public void toggleColumn(TableColumn column) {
        this.setColumnVisible(column.getHeaderValue().toString(), !this.isColumnVisible(column));
    }

    public final boolean isDetailPaneVisible() {
        return this.detailPaneVisible;
    }

    public final void setDetailPaneVisible(boolean detailPaneVisible) {
        boolean oldValue = this.detailPaneVisible;
        this.detailPaneVisible = detailPaneVisible;
        this.propertySupport.firePropertyChange("detailPaneVisible", oldValue, this.detailPaneVisible);
    }

    public final boolean isScrollToBottom() {
        return this.scrollToBottom;
    }

    public final boolean isShowMillisDeltaAsGap() {
        return this.showMillisDeltaAsGap;
    }

    public final void setScrollToBottom(boolean scrollToBottom) {
        boolean oldValue = this.scrollToBottom;
        this.scrollToBottom = scrollToBottom;
        this.propertySupport.firePropertyChange("scrollToBottom", oldValue, this.scrollToBottom);
    }

    public final void setShowMillisDeltaAsGap(boolean showMillisDeltaAsGap) {
        boolean oldValue = this.showMillisDeltaAsGap;
        this.showMillisDeltaAsGap = showMillisDeltaAsGap;
        this.propertySupport.firePropertyChange("showMillisDeltaAsGap", oldValue, this.showMillisDeltaAsGap);
    }

    public final void setThumbnailBarToolTips(boolean thumbnailBarToolTips) {
        boolean oldValue = this.thumbnailBarToolTips;
        this.thumbnailBarToolTips = thumbnailBarToolTips;
        this.propertySupport.firePropertyChange("thumbnailBarToolTips", oldValue, this.thumbnailBarToolTips);
    }

    public final boolean isThumbnailBarToolTips() {
        return this.thumbnailBarToolTips;
    }

    public final boolean isToolTips() {
        return this.toolTips;
    }

    public final void setToolTips(boolean toolTips) {
        boolean oldValue = this.toolTips;
        this.toolTips = toolTips;
        this.propertySupport.firePropertyChange("toolTips", oldValue, this.toolTips);
    }

    public final boolean isLogTreePanelVisible() {
        return this.logTreePanelVisible;
    }

    public final void setLogTreePanelVisible(boolean logTreePanelVisible) {
        boolean oldValue = this.logTreePanelVisible;
        this.logTreePanelVisible = logTreePanelVisible;
        this.propertySupport.firePropertyChange("logTreePanelVisible", oldValue, this.logTreePanelVisible);
    }

    public boolean isCustomDateFormat() {
        return !DATE_FORMATS.contains(this.getDateFormatPattern()) && !this.isUseISO8601Format();
    }

    public void setHiddenLoggers(Collection hiddenSet) {
        Collection oldValue = this.hiddenLoggers;
        this.hiddenLoggers = hiddenSet;
        this.propertySupport.firePropertyChange("hiddenLoggers", oldValue, this.hiddenLoggers);
    }

    public Collection getHiddenLoggers() {
        return this.hiddenLoggers;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        String oldValue = this.timeZone;
        this.timeZone = timeZone;
        this.propertySupport.firePropertyChange("dateFormatTimeZone", oldValue, this.timeZone);
    }

    public void setHiddenExpression(String hiddenExpression) {
        String oldValue = this.hiddenExpression;
        this.hiddenExpression = hiddenExpression;
        this.propertySupport.firePropertyChange("hiddenExpression", oldValue, this.hiddenExpression);
    }

    public String getHiddenExpression() {
        return this.hiddenExpression;
    }

    public void setAlwaysDisplayExpression(String alwaysDisplayExpression) {
        String oldValue = this.hiddenExpression;
        this.alwaysDisplayExpression = alwaysDisplayExpression;
        this.propertySupport.firePropertyChange("alwaysDisplayExpression", oldValue, this.alwaysDisplayExpression);
    }

    public String getAlwaysDisplayExpression() {
        return this.alwaysDisplayExpression;
    }

    public void setClearTableExpression(String clearTableExpression) {
        String oldValue = this.clearTableExpression;
        this.clearTableExpression = clearTableExpression;
        if (oldValue == null && this.clearTableExpression == null) {
            return;
        }
        this.propertySupport.firePropertyChange("clearTableExpression", oldValue, this.clearTableExpression);
    }

    public String getClearTableExpression() {
        return this.clearTableExpression;
    }

    static {
        ArrayList<Object> list = new ArrayList<Object>();
        Properties properties = SettingsManager.getInstance().getDefaultSettings();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!entry.getKey().toString().startsWith("DateFormat")) continue;
            list.add(entry.getValue());
        }
        DATE_FORMATS = Collections.unmodifiableCollection(list);
    }
}

