/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.mlt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.legacy.LegacyNumericUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.SolrPluginUtils;

public class SimpleMLTQParser
extends QParser {
    private static final Pattern splitList = Pattern.compile(",| ");

    public SimpleMLTQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() {
        String defaultField = this.req.getSchema().getUniqueKeyField().getName();
        String uniqueValue = this.localParams.get("v");
        String[] qf = this.localParams.getParams("qf");
        SolrIndexSearcher searcher = this.req.getSearcher();
        Query docIdQuery = this.createIdQuery(defaultField, uniqueValue);
        Map<Object, Object> boostFields = new HashMap();
        try {
            String[] fieldNames;
            TopDocs td = searcher.search(docIdQuery, 2);
            if (td.totalHits.value != 1L) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request. Could not fetch document with id [" + uniqueValue + "]");
            }
            ScoreDoc[] scoreDocs = td.scoreDocs;
            MoreLikeThis mlt = new MoreLikeThis((IndexReader)this.req.getSearcher().getIndexReader());
            mlt.setMinTermFreq(this.localParams.getInt("mintf", 2));
            mlt.setMinDocFreq(this.localParams.getInt("mindf", 5));
            mlt.setMinWordLen(this.localParams.getInt("minwl", 0));
            mlt.setMaxWordLen(this.localParams.getInt("maxwl", 0));
            mlt.setMaxQueryTerms(this.localParams.getInt("maxqt", 25));
            mlt.setMaxNumTokensParsed(this.localParams.getInt("maxntp", 5000));
            mlt.setMaxDocFreq(this.localParams.getInt("maxdf", Integer.MAX_VALUE));
            Boolean boost = this.localParams.getBool("boost", false);
            mlt.setBoost(boost.booleanValue());
            if (qf != null) {
                ArrayList<String> fields = new ArrayList<String>();
                for (String fieldName : qf) {
                    String[] strings;
                    if (StringUtils.isEmpty((String)fieldName)) continue;
                    for (String string : strings = splitList.split(fieldName)) {
                        if (StringUtils.isEmpty((String)string)) continue;
                        fields.add(string);
                    }
                }
                boostFields = SolrPluginUtils.parseFieldBoosts(fields.toArray(new String[0]));
                fieldNames = boostFields.keySet().toArray(new String[0]);
            } else {
                Map<String, SchemaField> fieldDefinitions = this.req.getSearcher().getSchema().getFields();
                ArrayList<String> fields = new ArrayList<String>();
                for (Map.Entry<String, SchemaField> entry : fieldDefinitions.entrySet()) {
                    if (!entry.getValue().indexed() || !entry.getValue().stored() || entry.getValue().getType().getNumberType() != null) continue;
                    fields.add(entry.getKey());
                }
                fieldNames = fields.toArray(new String[0]);
            }
            if (fieldNames.length < 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis requires at least one similarity field: qf");
            }
            mlt.setFieldNames(fieldNames);
            mlt.setAnalyzer(this.req.getSchema().getIndexAnalyzer());
            Query rawMLTQuery = mlt.like(scoreDocs[0].doc);
            BooleanQuery boostedMLTQuery = (BooleanQuery)rawMLTQuery;
            if (boost.booleanValue() && boostFields.size() > 0) {
                BooleanQuery.Builder newQ = new BooleanQuery.Builder();
                newQ.setMinimumNumberShouldMatch(boostedMLTQuery.getMinimumNumberShouldMatch());
                for (BooleanClause clause : boostedMLTQuery) {
                    Float fieldBoost;
                    Query q = clause.getQuery();
                    float originalBoost = 1.0f;
                    if (q instanceof BoostQuery) {
                        BoostQuery bq = (BoostQuery)q;
                        q = bq.getQuery();
                        originalBoost = bq.getBoost();
                    }
                    q = (fieldBoost = (Float)boostFields.get(((TermQuery)q).getTerm().field())) != null ? new BoostQuery(q, fieldBoost.floatValue() * originalBoost) : clause.getQuery();
                    newQ.add(q, clause.getOccur());
                }
                boostedMLTQuery = QueryUtils.build(newQ, this);
            }
            BooleanQuery.Builder realMLTQuery = new BooleanQuery.Builder();
            realMLTQuery.add((Query)boostedMLTQuery, BooleanClause.Occur.MUST);
            realMLTQuery.add(docIdQuery, BooleanClause.Occur.MUST_NOT);
            return realMLTQuery.build();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request" + e.getMessage());
        }
    }

    private Query createIdQuery(String defaultField, String uniqueValue) {
        return new TermQuery(this.req.getSchema().getField(defaultField).getType().getNumberType() != null ? this.createNumericTerm(defaultField, uniqueValue) : new Term(defaultField, uniqueValue));
    }

    private Term createNumericTerm(String field, String uniqueValue) {
        BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
        bytesRefBuilder.grow(6);
        LegacyNumericUtils.intToPrefixCoded(Integer.parseInt(uniqueValue), 0, bytesRefBuilder);
        return new Term(field, bytesRefBuilder);
    }
}

