/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$TrustedFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractTransformFuture$TransformFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.Futures;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ListenableFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.ForOverride;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractTransformFuture
extends AbstractFuture$TrustedFuture
implements Runnable {
    @Nullable ListenableFuture inputFuture;
    @Nullable Object function;

    static ListenableFuture create(ListenableFuture listenableFuture, Function function, Executor executor) {
        Preconditions.checkNotNull(function);
        AbstractTransformFuture$TransformFuture abstractTransformFuture$TransformFuture = new AbstractTransformFuture$TransformFuture(listenableFuture, function);
        listenableFuture.addListener(abstractTransformFuture$TransformFuture, MoreExecutors.rejectionPropagatingExecutor(executor, abstractTransformFuture$TransformFuture));
        return abstractTransformFuture$TransformFuture;
    }

    AbstractTransformFuture(ListenableFuture listenableFuture, Object object) {
        this.inputFuture = (ListenableFuture)Preconditions.checkNotNull(listenableFuture);
        this.function = Preconditions.checkNotNull(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object object;
        Object object2;
        ListenableFuture listenableFuture = this.inputFuture;
        Object object3 = this.function;
        if (this.isCancelled() | listenableFuture == null | object3 == null) {
            return;
        }
        this.inputFuture = null;
        try {
            object2 = Futures.getDone(listenableFuture);
        }
        catch (CancellationException cancellationException) {
            this.cancel(false);
            return;
        }
        catch (ExecutionException executionException) {
            this.setException(executionException.getCause());
            return;
        }
        catch (RuntimeException runtimeException) {
            this.setException(runtimeException);
            return;
        }
        catch (Error error) {
            this.setException(error);
            return;
        }
        try {
            object = this.doTransform(object3, object2);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            this.setException(undeclaredThrowableException.getCause());
            return;
        }
        catch (Throwable throwable) {
            this.setException(throwable);
            return;
        }
        finally {
            this.function = null;
        }
        this.setResult(object);
    }

    @ForOverride
    abstract @Nullable Object doTransform(Object var1, @Nullable Object var2);

    @ForOverride
    abstract void setResult(@Nullable Object var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.function = null;
    }

    @Override
    protected String pendingToString() {
        ListenableFuture listenableFuture = this.inputFuture;
        Object object = this.function;
        String string = super.pendingToString();
        String string2 = "";
        if (listenableFuture != null) {
            string2 = "inputFuture=[" + listenableFuture + "], ";
        }
        if (object != null) {
            return string2 + "function=[" + object + "]";
        }
        if (string != null) {
            return string2 + string;
        }
        return null;
    }
}

