/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.RepositoryAwareRequest;
import org.apache.maven.api.services.RequestTrace;

@Experimental
@Immutable
public interface ArtifactResolverRequest
extends RepositoryAwareRequest {
    @Nonnull
    public Collection<? extends ArtifactCoordinates> getCoordinates();

    @Nonnull
    public static ArtifactResolverRequestBuilder builder() {
        return new ArtifactResolverRequestBuilder();
    }

    @Nonnull
    public static ArtifactResolverRequest build(@Nonnull Session session, @Nonnull Collection<? extends ArtifactCoordinates> coordinates) {
        return ArtifactResolverRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).coordinates(Objects.requireNonNull(coordinates, "coordinates cannot be null")).build();
    }

    @Nonnull
    public static ArtifactResolverRequest build(@Nonnull Session session, @Nonnull Collection<? extends ArtifactCoordinates> coordinates, List<RemoteRepository> repositories) {
        return ArtifactResolverRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).coordinates(Objects.requireNonNull(coordinates, "coordinates cannot be null")).repositories(repositories).build();
    }

    @NotThreadSafe
    public static class ArtifactResolverRequestBuilder {
        Session session;
        RequestTrace trace;
        Collection<? extends ArtifactCoordinates> coordinates;
        List<RemoteRepository> repositories;

        ArtifactResolverRequestBuilder() {
        }

        @Nonnull
        public ArtifactResolverRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        @Nonnull
        public ArtifactResolverRequestBuilder trace(RequestTrace trace) {
            this.trace = trace;
            return this;
        }

        @Nonnull
        public ArtifactResolverRequestBuilder coordinates(Collection<? extends ArtifactCoordinates> coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        @Nonnull
        public ArtifactResolverRequestBuilder repositories(List<RemoteRepository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public ArtifactResolverRequest build() {
            return new DefaultArtifactResolverRequest(this.session, this.trace, this.coordinates, this.repositories);
        }

        private static class DefaultArtifactResolverRequest
        extends BaseRequest<Session>
        implements ArtifactResolverRequest {
            @Nonnull
            private final Collection<? extends ArtifactCoordinates> coordinates;
            @Nullable
            private final List<RemoteRepository> repositories;

            DefaultArtifactResolverRequest(@Nonnull Session session, @Nullable RequestTrace trace, @Nonnull Collection<? extends ArtifactCoordinates> coordinates, @Nonnull List<RemoteRepository> repositories) {
                super(session, trace);
                this.coordinates = List.copyOf(Objects.requireNonNull(coordinates, "coordinates cannot be null"));
                this.repositories = this.validate(repositories);
            }

            @Override
            @Nonnull
            public Collection<? extends ArtifactCoordinates> getCoordinates() {
                return this.coordinates;
            }

            @Override
            @Nullable
            public List<RemoteRepository> getRepositories() {
                return this.repositories;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object o) {
                if (!(o instanceof DefaultArtifactResolverRequest)) return false;
                DefaultArtifactResolverRequest that = (DefaultArtifactResolverRequest)o;
                if (!Objects.equals(this.coordinates, that.coordinates)) return false;
                if (!Objects.equals(this.repositories, that.repositories)) return false;
                return true;
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.coordinates, this.repositories);
            }

            @Override
            @Nonnull
            public String toString() {
                return "ArtifactResolverRequest[coordinates=" + String.valueOf(this.coordinates) + ", repositories=" + String.valueOf(this.repositories) + "]";
            }
        }
    }
}

