/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.FontFactoryImp;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.Watermark;
import com.lowagie.text.html.simpleparser.ALink;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import com.lowagie.text.html.simpleparser.FactoryProperties;
import com.lowagie.text.html.simpleparser.Img;
import com.lowagie.text.html.simpleparser.IncCell;
import com.lowagie.text.html.simpleparser.IncTable;
import com.lowagie.text.html.simpleparser.StyleSheet;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.SimpleXMLDocHandler;
import com.lowagie.text.pdf.SimpleXMLParser;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;

public class HTMLWorker
implements SimpleXMLDocHandler,
DocListener {
    protected ArrayList objectList;
    protected DocListener document;
    private Paragraph currentParagraph;
    private ChainedProperties cprops = new ChainedProperties();
    private Stack stack = new Stack();
    private boolean pendingTR = false;
    private boolean pendingTD = false;
    private boolean pendingLI = false;
    private StyleSheet style = new StyleSheet();
    private boolean isPRE = false;
    private Stack tableState = new Stack();
    private boolean skipText = false;
    private HashMap interfaceProps;
    private FactoryProperties factoryProperties = new FactoryProperties();
    public static final String tagsSupportedString = "ol ul li a pre font span br p div body table td th tr i b u sub sup em strong h1 h2 h3 h4 h5 h6 img";
    public static final HashMap tagsSupported = new HashMap();

    static {
        StringTokenizer tok = new StringTokenizer(tagsSupportedString);
        while (tok.hasMoreTokens()) {
            tagsSupported.put(tok.nextToken(), null);
        }
    }

    public HTMLWorker(DocListener document) {
        this.document = document;
    }

    public void setStyleSheet(StyleSheet style) {
        this.style = style;
    }

    public StyleSheet getStyleSheet() {
        return this.style;
    }

    public void setInterfaceProps(HashMap interfaceProps) {
        this.interfaceProps = interfaceProps;
        FontFactoryImp ff = null;
        if (interfaceProps != null) {
            ff = (FontFactoryImp)interfaceProps.get("font_factory");
        }
        if (ff != null) {
            this.factoryProperties.setFontImp(ff);
        }
    }

    public HashMap getInterfaceProps() {
        return this.interfaceProps;
    }

    public void parse(Reader reader) throws IOException {
        SimpleXMLParser.parse(this, null, reader, true);
    }

    public static ArrayList parseToList(Reader reader, StyleSheet style) throws IOException {
        return HTMLWorker.parseToList(reader, style, null);
    }

    public static ArrayList parseToList(Reader reader, StyleSheet style, HashMap interfaceProps) throws IOException {
        HTMLWorker worker = new HTMLWorker(null);
        if (style != null) {
            worker.style = style;
        }
        worker.document = worker;
        worker.setInterfaceProps(interfaceProps);
        worker.objectList = new ArrayList();
        worker.parse(reader);
        return worker.objectList;
    }

    public void endDocument() {
        try {
            int k = 0;
            while (k < this.stack.size()) {
                this.document.add((Element)this.stack.elementAt(k));
                ++k;
            }
            if (this.currentParagraph != null) {
                this.document.add(this.currentParagraph);
            }
            this.currentParagraph = null;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void startDocument() {
        HashMap h = new HashMap();
        this.style.applyStyle("body", h);
        this.cprops.addToChain("body", h);
    }

    public void startElement(String tag, HashMap h) {
        if (!tagsSupported.containsKey(tag)) {
            return;
        }
        try {
            this.style.applyStyle(tag, h);
            String follow = (String)FactoryProperties.followTags.get(tag);
            if (follow != null) {
                HashMap<String, Object> prop = new HashMap<String, Object>();
                prop.put(follow, null);
                this.cprops.addToChain(follow, prop);
                return;
            }
            FactoryProperties.insertStyle(h);
            if (tag.equals("a")) {
                this.cprops.addToChain(tag, h);
                if (this.currentParagraph == null) {
                    this.currentParagraph = new Paragraph();
                }
                this.stack.push(this.currentParagraph);
                this.currentParagraph = new Paragraph();
                return;
            }
            if (tag.equals("br")) {
                if (this.currentParagraph == null) {
                    this.currentParagraph = new Paragraph();
                }
                this.currentParagraph.add(this.factoryProperties.createChunk("\n", this.cprops));
                return;
            }
            if (tag.equals("font") || tag.equals("span")) {
                this.cprops.addToChain(tag, h);
                return;
            }
            if (tag.equals("img")) {
                String src = (String)h.get("src");
                if (src == null) {
                    return;
                }
                this.cprops.addToChain(tag, h);
                Image img = null;
                if (this.interfaceProps != null) {
                    String baseurl;
                    HashMap images = (HashMap)this.interfaceProps.get("img_static");
                    if (images != null) {
                        Image tim = (Image)images.get(src);
                        if (tim != null) {
                            img = Image.getInstance(tim);
                        }
                    } else if (!src.startsWith("http") && (baseurl = (String)this.interfaceProps.get("img_baseurl")) != null) {
                        src = String.valueOf(baseurl) + src;
                        img = Image.getInstance(src);
                    }
                }
                if (img == null) {
                    if (!src.startsWith("http")) {
                        String path = this.cprops.getProperty("image_path");
                        if (path == null) {
                            path = "";
                        }
                        src = new File(path, src).getPath();
                    }
                    img = Image.getInstance(src);
                }
                String align = (String)h.get("align");
                String width = (String)h.get("width");
                String height = (String)h.get("height");
                String before = this.cprops.getProperty("before");
                String after = this.cprops.getProperty("after");
                if (before != null) {
                    img.setSpacingBefore(Float.parseFloat(before));
                }
                if (after != null) {
                    img.setSpacingAfter(Float.parseFloat(after));
                }
                float wp = HTMLWorker.lengthParse(width, (int)img.width());
                float lp = HTMLWorker.lengthParse(height, (int)img.height());
                if (wp > 0.0f && lp > 0.0f) {
                    img.scalePercent(wp > lp ? lp : wp);
                } else if (wp > 0.0f) {
                    img.scalePercent(wp);
                } else if (lp > 0.0f) {
                    img.scalePercent(lp);
                }
                img.setWidthPercentage(0.0f);
                if (align != null) {
                    this.endElement("p");
                    int ralign = 1;
                    if (align.equalsIgnoreCase("left")) {
                        ralign = 0;
                    } else if (align.equalsIgnoreCase("right")) {
                        ralign = 2;
                    }
                    img.setAlignment(ralign);
                    Img i = null;
                    boolean skip = false;
                    if (this.interfaceProps != null && (i = (Img)this.interfaceProps.get("img_interface")) != null) {
                        skip = i.process(img, h, this.cprops, this.document);
                    }
                    if (!skip) {
                        this.document.add(img);
                    }
                    this.cprops.removeChain(tag);
                } else {
                    this.cprops.removeChain(tag);
                    if (this.currentParagraph == null) {
                        this.currentParagraph = FactoryProperties.createParagraph(this.cprops);
                    }
                    this.currentParagraph.add(new Chunk(img, 0.0f, 0.0f));
                }
                return;
            }
            this.endElement("p");
            if (tag.equals("h1") || tag.equals("h2") || tag.equals("h3") || tag.equals("h4") || tag.equals("h5") || tag.equals("h6")) {
                if (!h.containsKey("size")) {
                    int v = 7 - Integer.parseInt(tag.substring(1));
                    h.put("size", Integer.toString(v));
                }
                this.cprops.addToChain(tag, h);
                return;
            }
            if (tag.equals("ul")) {
                if (this.pendingLI) {
                    this.endElement("li");
                }
                this.skipText = true;
                this.cprops.addToChain(tag, h);
                List list = new List(false, 10.0f);
                list.setListSymbol("\u2022");
                this.stack.push(list);
                return;
            }
            if (tag.equals("ol")) {
                if (this.pendingLI) {
                    this.endElement("li");
                }
                this.skipText = true;
                this.cprops.addToChain(tag, h);
                List list = new List(true, 10.0f);
                this.stack.push(list);
                return;
            }
            if (tag.equals("li")) {
                if (this.pendingLI) {
                    this.endElement("li");
                }
                this.skipText = false;
                this.pendingLI = true;
                this.cprops.addToChain(tag, h);
                this.stack.push(FactoryProperties.createListItem(this.cprops));
                return;
            }
            if (tag.equals("div") || tag.equals("body")) {
                this.cprops.addToChain(tag, h);
                return;
            }
            if (tag.equals("pre")) {
                if (!h.containsKey("face")) {
                    h.put("face", "Courier");
                }
                this.cprops.addToChain(tag, h);
                this.isPRE = true;
                return;
            }
            if (tag.equals("p")) {
                this.cprops.addToChain(tag, h);
                this.currentParagraph = FactoryProperties.createParagraph(h);
                return;
            }
            if (tag.equals("tr")) {
                if (this.pendingTR) {
                    this.endElement("tr");
                }
                this.skipText = true;
                this.pendingTR = true;
                this.cprops.addToChain("tr", h);
                return;
            }
            if (tag.equals("td") || tag.equals("th")) {
                if (this.pendingTD) {
                    this.endElement(tag);
                }
                this.skipText = false;
                this.pendingTD = true;
                this.cprops.addToChain("td", h);
                this.stack.push(new IncCell(tag, this.cprops));
                return;
            }
            if (tag.equals("table")) {
                this.cprops.addToChain("table", h);
                IncTable table = new IncTable(h);
                this.stack.push(table);
                this.tableState.push(new boolean[]{this.pendingTR, this.pendingTD});
                this.pendingTD = false;
                this.pendingTR = false;
                this.skipText = true;
                return;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void endElement(String tag) {
        if (!tagsSupported.containsKey(tag)) {
            return;
        }
        try {
            Object obj;
            String follow = (String)FactoryProperties.followTags.get(tag);
            if (follow != null) {
                this.cprops.removeChain(follow);
                return;
            }
            if (tag.equals("font") || tag.equals("span")) {
                this.cprops.removeChain(tag);
                return;
            }
            if (tag.equals("a")) {
                String href;
                if (this.currentParagraph == null) {
                    this.currentParagraph = new Paragraph();
                }
                ALink i = null;
                boolean skip = false;
                if (this.interfaceProps != null && (i = (ALink)this.interfaceProps.get("alink_interface")) != null) {
                    skip = i.process(this.currentParagraph, this.cprops);
                }
                if (!skip && (href = this.cprops.getProperty("href")) != null) {
                    ArrayList chunks = this.currentParagraph.getChunks();
                    int k = 0;
                    while (k < chunks.size()) {
                        Chunk ck = (Chunk)chunks.get(k);
                        ck.setAnchor(href);
                        ++k;
                    }
                }
                Paragraph tmp = (Paragraph)this.stack.pop();
                Phrase tmp2 = new Phrase();
                tmp2.add(this.currentParagraph);
                tmp.add(tmp2);
                this.currentParagraph = tmp;
                this.cprops.removeChain("a");
                return;
            }
            if (tag.equals("br")) {
                return;
            }
            if (this.currentParagraph != null) {
                if (this.stack.empty()) {
                    this.document.add(this.currentParagraph);
                } else {
                    obj = this.stack.pop();
                    if (obj instanceof TextElementArray) {
                        TextElementArray current = (TextElementArray)obj;
                        current.add(this.currentParagraph);
                    }
                    this.stack.push(obj);
                }
            }
            this.currentParagraph = null;
            if (tag.equals("ul") || tag.equals("ol")) {
                if (this.pendingLI) {
                    this.endElement("li");
                }
                this.skipText = false;
                this.cprops.removeChain(tag);
                if (this.stack.empty()) {
                    return;
                }
                obj = this.stack.pop();
                if (!(obj instanceof List)) {
                    this.stack.push(obj);
                    return;
                }
                if (this.stack.empty()) {
                    this.document.add((Element)obj);
                } else {
                    ((TextElementArray)this.stack.peek()).add(obj);
                }
                return;
            }
            if (tag.equals("li")) {
                this.pendingLI = false;
                this.skipText = true;
                this.cprops.removeChain(tag);
                if (this.stack.empty()) {
                    return;
                }
                obj = this.stack.pop();
                if (!(obj instanceof ListItem)) {
                    this.stack.push(obj);
                    return;
                }
                if (this.stack.empty()) {
                    this.document.add((Element)obj);
                    return;
                }
                Object list = this.stack.pop();
                if (!(list instanceof List)) {
                    this.stack.push(list);
                    return;
                }
                ListItem item = (ListItem)obj;
                ((List)list).add(item);
                ArrayList cks = item.getChunks();
                if (!cks.isEmpty()) {
                    item.listSymbol().setFont(((Chunk)cks.get(0)).font());
                }
                this.stack.push(list);
                return;
            }
            if (tag.equals("div") || tag.equals("body")) {
                this.cprops.removeChain(tag);
                return;
            }
            if (tag.equals("pre")) {
                this.cprops.removeChain(tag);
                this.isPRE = false;
                return;
            }
            if (tag.equals("p")) {
                this.cprops.removeChain(tag);
                return;
            }
            if (tag.equals("h1") || tag.equals("h2") || tag.equals("h3") || tag.equals("h4") || tag.equals("h5") || tag.equals("h6")) {
                this.cprops.removeChain(tag);
                return;
            }
            if (tag.equals("table")) {
                if (this.pendingTR) {
                    this.endElement("tr");
                }
                this.cprops.removeChain("table");
                IncTable table = (IncTable)this.stack.pop();
                PdfPTable tb = table.buildTable();
                tb.setSplitRows(true);
                if (this.stack.empty()) {
                    this.document.add(tb);
                } else {
                    ((TextElementArray)this.stack.peek()).add(tb);
                }
                boolean[] state = (boolean[])this.tableState.pop();
                this.pendingTR = state[0];
                this.pendingTD = state[1];
                this.skipText = false;
                return;
            }
            if (tag.equals("tr")) {
                Object obj2;
                if (this.pendingTD) {
                    this.endElement("td");
                }
                this.pendingTR = false;
                this.cprops.removeChain("tr");
                ArrayList<PdfPCell> cells = new ArrayList<PdfPCell>();
                IncTable table = null;
                do {
                    if (!((obj2 = this.stack.pop()) instanceof IncCell)) continue;
                    cells.add(((IncCell)obj2).getCell());
                } while (!(obj2 instanceof IncTable));
                table = (IncTable)obj2;
                table.addCols(cells);
                table.endRow();
                this.stack.push(table);
                this.skipText = true;
                return;
            }
            if (tag.equals("td") || tag.equals("th")) {
                this.pendingTD = false;
                this.cprops.removeChain("td");
                this.skipText = true;
                return;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void text(String str) {
        if (this.skipText) {
            return;
        }
        String content = str;
        if (this.isPRE) {
            if (this.currentParagraph == null) {
                this.currentParagraph = new Paragraph();
            }
            this.currentParagraph.add(this.factoryProperties.createChunk(content, this.cprops));
            return;
        }
        if (content.trim().length() == 0 && content.indexOf(32) < 0) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        int len = content.length();
        boolean newline = false;
        int i = 0;
        while (i < len) {
            char character = content.charAt(i);
            switch (character) {
                case ' ': {
                    if (newline) break;
                    buf.append(character);
                    break;
                }
                case '\n': {
                    if (i <= 0) break;
                    newline = true;
                    buf.append(' ');
                    break;
                }
                case '\r': {
                    break;
                }
                case '\t': {
                    break;
                }
                default: {
                    newline = false;
                    buf.append(character);
                }
            }
            ++i;
        }
        if (this.currentParagraph == null) {
            this.currentParagraph = FactoryProperties.createParagraph(this.cprops);
        }
        this.currentParagraph.add(this.factoryProperties.createChunk(buf.toString(), this.cprops));
    }

    public boolean add(Element element) throws DocumentException {
        this.objectList.add(element);
        return true;
    }

    public boolean add(Watermark watermark) {
        return true;
    }

    public void clearTextWrap() throws DocumentException {
    }

    public void close() {
    }

    public boolean newPage() throws DocumentException {
        return true;
    }

    public void open() {
    }

    public void removeWatermark() {
    }

    public void resetFooter() {
    }

    public void resetHeader() {
    }

    public void resetPageCount() {
    }

    public void setFooter(HeaderFooter footer) {
    }

    public void setHeader(HeaderFooter header) {
    }

    public boolean setMarginMirroring(boolean marginMirroring) {
        return true;
    }

    public boolean setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        return true;
    }

    public void setPageCount(int pageN) {
    }

    public boolean setPageSize(Rectangle pageSize) {
        return true;
    }

    private static float lengthParse(String txt, int c) {
        if (txt == null) {
            return -1.0f;
        }
        if (txt.endsWith("%")) {
            float vf = Float.parseFloat(txt.substring(0, txt.length() - 1));
            return vf;
        }
        int v = Integer.parseInt(txt);
        return (float)v / (float)c * 100.0f;
    }
}

