/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitFactoryImpl
extends RenderKitFactory {
    private static final Logger log = Logger.getLogger(RenderKitFactoryImpl.class.getName());
    private Map<String, RenderKit> _renderkits = new HashMap<String, RenderKit>();

    public void purgeRenderKit() {
        this._renderkits.clear();
    }

    @Override
    public void addRenderKit(String renderKitId, RenderKit renderKit) {
        if (renderKitId == null) {
            throw new NullPointerException("renderKitId");
        }
        if (renderKit == null) {
            throw new NullPointerException("renderKit");
        }
        if (log.isLoggable(Level.INFO) && this._renderkits.containsKey(renderKitId)) {
            log.info("RenderKit with renderKitId '" + renderKitId + "' was replaced.");
        }
        this._renderkits.put(renderKitId, renderKit);
    }

    @Override
    public RenderKit getRenderKit(FacesContext context, String renderKitId) throws FacesException {
        if (renderKitId == null) {
            throw new NullPointerException("renderKitId");
        }
        RenderKit renderkit = this._renderkits.get(renderKitId);
        if (renderkit == null) {
            log.warning("Unknown RenderKit '" + renderKitId + "'.");
        }
        return renderkit;
    }

    @Override
    public Iterator<String> getRenderKitIds() {
        return this._renderkits.keySet().iterator();
    }
}

