/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.TemplateClient;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.ui.DefineHandler;
import org.apache.myfaces.view.facelets.tag.ui.ParamHandler;

public final class CompositionHandler
extends TagHandler
implements TemplateClient {
    private static final Logger log = Logger.getLogger(CompositionHandler.class.getName());
    public static final String Name = "composition";
    protected final TagAttribute _template = this.getAttribute("template");
    protected final Map<String, DefineHandler> _handlers;
    protected final ParamHandler[] _params;

    public CompositionHandler(TagConfig config) {
        super(config);
        if (this._template != null) {
            this._handlers = new HashMap<String, DefineHandler>();
            for (DefineHandler handler : TagHandlerUtils.findNextByType(this.nextHandler, DefineHandler.class)) {
                this._handlers.put(handler.getName(), handler);
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine(this.tag + " found Define[" + handler.getName() + "]");
            }
            Collection<ParamHandler> params = TagHandlerUtils.findNextByType(this.nextHandler, ParamHandler.class);
            if (!params.isEmpty()) {
                int i = 0;
                this._params = new ParamHandler[params.size()];
                for (ParamHandler handler : params) {
                    this._params[i++] = handler;
                }
            } else {
                this._params = null;
            }
        } else {
            this._params = null;
            this._handlers = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (this._template != null) {
            AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
            actx.extendClient(this);
            if (this._params != null) {
                for (int i = 0; i < this._params.length; ++i) {
                    this._params[i].apply(ctx, parent);
                }
            }
            try {
                ctx.includeFacelet(parent, this._template.getValue(ctx));
            }
            finally {
                actx.popExtendedClient(this);
            }
        } else {
            this.nextHandler.apply(ctx, parent);
        }
    }

    public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
        if (name != null) {
            if (this._handlers == null) {
                return false;
            }
            DefineHandler handler = this._handlers.get(name);
            if (handler != null) {
                handler.applyDefinition(ctx, parent);
                return true;
            }
            return false;
        }
        this.nextHandler.apply(ctx, parent);
        return true;
    }
}

