/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UpdateModelException;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.SystemEvent;

public class PreJsf2ExceptionHandlerFactory
extends ExceptionHandlerFactory {
    private static final Logger log = Logger.getLogger(PreJsf2ExceptionHandlerFactory.class.getName());

    public ExceptionHandler getExceptionHandler() {
        return new PreJsf2ExceptionHandlerImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PreJsf2ExceptionHandlerImpl
    extends ExceptionHandler {
        private static final Logger log = Logger.getLogger(PreJsf2ExceptionHandlerImpl.class.getName());
        private static final String ERROR_HANDLER_PARAMETER = "org.apache.myfaces.ERROR_HANDLER";
        private Queue<ExceptionQueuedEvent> handled;
        private Queue<ExceptionQueuedEvent> unhandled;
        private ExceptionQueuedEvent handledAndThrown;

        @Override
        public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
            return this.handledAndThrown;
        }

        @Override
        public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
            return this.handled == null ? Collections.emptyList() : this.handled;
        }

        @Override
        public Throwable getRootCause(Throwable t) {
            if (t == null) {
                throw new NullPointerException("t");
            }
            while (t != null) {
                Class<?> clazz = t.getClass();
                if (!clazz.equals(FacesException.class) && !clazz.equals(ELException.class)) {
                    return t;
                }
                t = t.getCause();
            }
            return null;
        }

        @Override
        public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
            return this.unhandled == null ? Collections.emptyList() : this.unhandled;
        }

        @Override
        public void handle() throws FacesException {
            if (this.unhandled != null && !this.unhandled.isEmpty()) {
                if (this.handled == null) {
                    this.handled = new LinkedList<ExceptionQueuedEvent>();
                }
                String errorHandlerClass = FacesContext.getCurrentInstance().getExternalContext().getInitParameter(ERROR_HANDLER_PARAMETER);
                FacesException toThrow = null;
                do {
                    ExceptionQueuedEvent event = this.unhandled.peek();
                    try {
                        ExceptionQueuedEventContext context = event.getContext();
                        Throwable exception = context.getException();
                        if (errorHandlerClass != null) {
                            try {
                                Class<?> clazz = Class.forName(errorHandlerClass);
                                Object errorHandler = clazz.newInstance();
                                Method m = clazz.getMethod("handleException", FacesContext.class, Exception.class);
                                m.invoke(errorHandler, context.getContext(), exception);
                                continue;
                            }
                            catch (ClassNotFoundException ex) {
                                throw new FacesException("Error-Handler : " + errorHandlerClass + " was not found. Fix your web.xml-parameter : " + ERROR_HANDLER_PARAMETER, ex);
                            }
                            catch (IllegalAccessException ex) {
                                throw new FacesException("Constructor of error-Handler : " + errorHandlerClass + " is not accessible. Error-Handler is specified in web.xml-parameter : " + ERROR_HANDLER_PARAMETER, ex);
                            }
                            catch (InstantiationException ex) {
                                throw new FacesException("Error-Handler : " + errorHandlerClass + " could not be instantiated. Error-Handler is specified in web.xml-parameter : " + ERROR_HANDLER_PARAMETER, ex);
                            }
                            catch (NoSuchMethodException ex) {
                                throw new FacesException("Error-Handler : " + errorHandlerClass + " does not have a method with name : handleException and parameters : " + "javax.faces.context.FacesContext, java.lang.Exception. Error-Handler is" + "specified in web.xml-parameter : " + ERROR_HANDLER_PARAMETER, ex);
                            }
                            catch (InvocationTargetException ex) {
                                throw new FacesException("Excecution of method handleException in Error-Handler : " + errorHandlerClass + " caused an exception. Error-Handler is specified in web.xml-parameter : " + ERROR_HANDLER_PARAMETER, ex);
                            }
                        }
                        if (exception instanceof UpdateModelException) {
                            FacesMessage message = ((UpdateModelException)exception).getFacesMessage();
                            log.log(Level.SEVERE, message.getSummary(), exception.getCause());
                            UIComponent component = context.getComponent();
                            String clientId = null;
                            if (component != null) {
                                clientId = component.getClientId(context.getContext());
                            }
                            context.getContext().addMessage(clientId, message);
                            continue;
                        }
                        if (!(this.shouldSkip(exception) || context.inBeforePhase() || context.inAfterPhase())) {
                            this.handledAndThrown = event;
                            toThrow = this.wrap(this.getRethrownException(exception));
                            break;
                        }
                        log.log(Level.SEVERE, exception.getClass().getName() + " occured while processing " + (context.inBeforePhase() ? "beforePhase() of " : (context.inAfterPhase() ? "afterPhase() of " : "")) + "phase " + context.getPhaseId() + ": " + "UIComponent-ClientId=" + (context.getComponent() != null ? context.getComponent().getClientId(context.getContext()) : "") + ", " + "Message=" + exception.getMessage());
                        log.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                    catch (Throwable t) {
                        throw new FacesException("Could not perform the algorithm to handle the Exception", t);
                    }
                    finally {
                        this.handled.add(event);
                        this.unhandled.remove(event);
                    }
                } while (!this.unhandled.isEmpty());
                if (toThrow != null) {
                    throw toThrow;
                }
            }
        }

        @Override
        public boolean isListenerForSource(Object source) {
            return source instanceof ExceptionQueuedEventContext;
        }

        @Override
        public void processEvent(SystemEvent exceptionQueuedEvent) throws AbortProcessingException {
            if (this.unhandled == null) {
                this.unhandled = new LinkedList<ExceptionQueuedEvent>();
            }
            this.unhandled.add((ExceptionQueuedEvent)exceptionQueuedEvent);
        }

        protected Throwable getRethrownException(Throwable exception) {
            Throwable toRethrow = this.getRootCause(exception);
            if (toRethrow == null) {
                toRethrow = exception;
            }
            return toRethrow;
        }

        protected FacesException wrap(Throwable exception) {
            if (exception instanceof FacesException) {
                return (FacesException)exception;
            }
            return new FacesException(exception);
        }

        protected boolean shouldSkip(Throwable exception) {
            return exception instanceof AbortProcessingException;
        }
    }
}

