/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.MetadataTarget;
import org.apache.myfaces.util.lang.ClassUtils;

final class CompositeMetadataTargetImpl
extends MetadataTarget {
    private final Map<String, PropertyDescriptor> descriptors;
    private final MetadataTarget delegate;
    private final BeanInfo beanInfo;

    public CompositeMetadataTargetImpl(MetadataTarget delegate, BeanInfo beanInfo) throws IntrospectionException {
        this.delegate = delegate;
        this.beanInfo = beanInfo;
        this.descriptors = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            this.descriptors.put(descriptor.getName(), descriptor);
        }
    }

    @Override
    public PropertyDescriptor getProperty(String name) {
        PropertyDescriptor pd = this.delegate.getProperty(name);
        if (pd == null) {
            pd = this.descriptors.get(name);
        }
        return pd;
    }

    @Override
    public Class<?> getPropertyType(String name) {
        PropertyDescriptor pd = this.getProperty(name);
        if (pd != null) {
            Class<Object> type = pd.getValue("type");
            if (type != null) {
                if ((type = ((ValueExpression)type).getValue(FacesContext.getCurrentInstance().getELContext())) instanceof String) {
                    try {
                        type = ClassUtils.javaDefaultTypeToClass((String)((Object)type));
                    }
                    catch (ClassNotFoundException e) {
                        type = Object.class;
                    }
                }
                return type;
            }
            return pd.getPropertyType();
        }
        return null;
    }

    @Override
    public Method getReadMethod(String name) {
        PropertyDescriptor pd = this.getProperty(name);
        if (pd != null) {
            return pd.getReadMethod();
        }
        return null;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.delegate.getTargetClass();
    }

    @Override
    public Method getWriteMethod(String name) {
        PropertyDescriptor pd = this.getProperty(name);
        if (pd != null) {
            return pd.getWriteMethod();
        }
        return null;
    }

    @Override
    public boolean isTargetInstanceOf(Class type) {
        return this.delegate.isTargetInstanceOf(type);
    }
}

