/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf;

import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.MetaTagHandler;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.view.facelets.tag.MetaRulesetImpl;
import org.apache.myfaces.view.facelets.tag.jsf.ActionSourceRule;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentRule;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.jsf.EditableValueHolderRule;
import org.apache.myfaces.view.facelets.tag.jsf.ValueHolderRule;

@Deprecated
public class ComponentHandler
extends MetaTagHandler {
    private static final Logger log = Logger.getLogger(ComponentHandler.class.getName());
    private final TagAttribute binding;
    private final String componentType;
    private final TagAttribute id;
    private final String rendererType;

    public ComponentHandler(ComponentConfig config) {
        super((TagConfig)config);
        this.componentType = config.getComponentType();
        this.rendererType = config.getRendererType();
        this.id = this.getAttribute("id");
        this.binding = this.getAttribute("binding");
    }

    public final void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        if (parent == null) {
            throw new TagException(this.tag, "Parent UIComponent was null");
        }
        String facetName = this.getFacetName(ctx, parent);
        String id = ctx.generateUniqueId(this.tagId);
        UIComponent c = ComponentSupport.findChildByTagId(parent, id);
        boolean componentFound = false;
        if (c != null) {
            componentFound = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.tag + " Component[" + id + "] Found, marking children for cleanup");
            }
            ComponentSupport.markForDeletion(c);
        } else {
            c = this.createComponent(ctx);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.tag + " Component[" + id + "] Created: " + c.getClass().getName());
            }
            this.setAttributes(ctx, c);
            c.getAttributes().put("oam.vf.MARK_ID", id);
            if (this.id != null) {
                c.setId(this.id.getValue(ctx));
            } else {
                UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
                if (root != null) {
                    String uid = root.createUniqueId();
                    c.setId(uid);
                }
            }
            if (this.rendererType != null) {
                c.setRendererType(this.rendererType);
            }
            this.onComponentCreated(ctx, c, parent);
        }
        this.applyNextHandler(ctx, c);
        if (componentFound) {
            ComponentSupport.finalizeForDeletion(c);
            if (facetName == null) {
                parent.getChildren().remove(c);
            }
        }
        this.onComponentPopulated(ctx, c, parent);
        if (facetName == null) {
            parent.getChildren().add(c);
        } else {
            parent.getFacets().put(facetName, c);
        }
    }

    protected final String getFacetName(FaceletContext ctx, UIComponent parent) {
        return (String)parent.getAttributes().get("facelets.FACET_NAME");
    }

    protected UIComponent createComponent(FaceletContext ctx) {
        UIComponent c = null;
        FacesContext faces = ctx.getFacesContext();
        Application app = faces.getApplication();
        if (this.binding != null) {
            ValueExpression ve = this.binding.getValueExpression(ctx, Object.class);
            c = app.createComponent(ve, faces, this.componentType);
            if (c != null) {
                c.setValueExpression("binding", ve);
            }
        } else {
            c = app.createComponent(this.componentType);
        }
        return c;
    }

    protected String getId(FaceletContext ctx) {
        if (this.id != null) {
            return this.id.getValue(ctx);
        }
        return ctx.generateUniqueId(this.tagId);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRulesetImpl m = new MetaRulesetImpl(this.tag, type);
        m.ignore("binding").ignore("id");
        m.addRule(ComponentRule.INSTANCE);
        if (ActionSource.class.isAssignableFrom(type)) {
            m.addRule(ActionSourceRule.INSTANCE);
        }
        if (ValueHolder.class.isAssignableFrom(type)) {
            m.addRule(ValueHolderRule.INSTANCE);
            if (EditableValueHolder.class.isAssignableFrom(type)) {
                m.ignore("submittedValue");
                m.ignore("valid");
                m.addRule(EditableValueHolderRule.INSTANCE);
            }
        }
        return m;
    }

    protected void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
    }

    protected void onComponentPopulated(FaceletContext ctx, UIComponent c, UIComponent parent) {
    }

    protected void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        this.nextHandler.apply(ctx, c);
    }
}

