/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.application;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.ResponseStateManager;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.shared.application.CheckedViewIdsCache;
import org.apache.myfaces.shared.application.FacesServletMapping;
import org.apache.myfaces.shared.application.FacesServletMappingUtils;
import org.apache.myfaces.shared.application.InvalidViewIdException;
import org.apache.myfaces.shared.application.ViewHandlerSupport;
import org.apache.myfaces.shared.renderkit.html.util.SharedStringBuilder;
import org.apache.myfaces.shared.util.ExternalContextUtils;
import org.apache.myfaces.shared.util.StringUtils;
import org.apache.myfaces.shared.util.ViewProtectionUtils;

public class DefaultViewHandlerSupport
implements ViewHandlerSupport {
    private static final String CACHED_SERVLET_MAPPING = DefaultViewHandlerSupport.class.getName() + ".CACHED_SERVLET_MAPPING";
    private static final Logger log = Logger.getLogger(DefaultViewHandlerSupport.class.getName());
    private static final String VIEW_HANDLER_SUPPORT_SB = "oam.viewhandler.SUPPORT_SB";
    private final String[] _faceletsViewMappings;
    private final String[] _contextSuffixes;
    private final String _faceletsContextSufix;
    private final boolean _initialized;
    private CheckedViewIdsCache checkedViewIdsCache = null;

    public DefaultViewHandlerSupport() {
        this._faceletsViewMappings = null;
        this._contextSuffixes = null;
        this._faceletsContextSufix = null;
        this._initialized = false;
    }

    public DefaultViewHandlerSupport(FacesContext facesContext) {
        this._faceletsViewMappings = this.getFaceletsViewMappings(facesContext);
        this._contextSuffixes = this.getContextSuffix(facesContext);
        this._faceletsContextSufix = this.getFaceletsContextSuffix(facesContext);
        this._initialized = true;
    }

    @Override
    public String calculateViewId(FacesContext context, String viewId) {
        if (viewId == null) {
            return null;
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        if (mapping == null || mapping.isExtensionMapping()) {
            viewId = this.handleSuffixMapping(context, viewId);
        } else if (mapping.isExactMapping()) {
            if (viewId.equals(mapping.getExact())) {
                viewId = this.handleSuffixMapping(context, viewId + ".jsf");
            }
        } else if (mapping.isPrefixMapping()) {
            if ((viewId = this.handlePrefixMapping(viewId, mapping.getPrefix())) != null && viewId.equals(mapping.getPrefix()) && !ExternalContextUtils.isPortlet(context.getExternalContext())) {
                throw new InvalidViewIdException();
            }
            if (viewId != null && viewId.equals(mapping.getPrefix())) {
                viewId = this.handleSuffixMapping(context, viewId + ".jsf");
            }
        } else if (mapping.getUrlPattern().startsWith(viewId)) {
            throw new InvalidViewIdException(viewId);
        }
        return viewId;
    }

    @Override
    public String calculateAndCheckViewId(FacesContext context, String viewId) {
        if (viewId == null) {
            return null;
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        if (mapping == null || mapping.isExtensionMapping()) {
            viewId = this.handleSuffixMapping(context, viewId);
        } else if (mapping.isExactMapping()) {
            if (viewId.equals(mapping.getExact())) {
                viewId = this.handleSuffixMapping(context, viewId + ".jsf");
            }
        } else if (mapping.isPrefixMapping()) {
            if ((viewId = this.handlePrefixMapping(viewId, mapping.getPrefix())) != null) {
                if (viewId != null && viewId.equals(mapping.getPrefix())) {
                    viewId = this.handleSuffixMapping(context, viewId + ".jsf");
                }
                return this.checkResourceExists(context, viewId) ? viewId : null;
            }
        } else {
            if (mapping.getUrlPattern().startsWith(viewId)) {
                throw new InvalidViewIdException(viewId);
            }
            if (viewId != null) {
                return this.checkResourceExists(context, viewId) ? viewId : null;
            }
        }
        return viewId;
    }

    @Override
    public String calculateActionURL(FacesContext context, String viewId) {
        String exactMappingViewId;
        if (viewId == null || !viewId.startsWith("/")) {
            throw new IllegalArgumentException("ViewId must start with a '/': " + viewId);
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        ExternalContext externalContext = context.getExternalContext();
        String contextPath = externalContext.getRequestContextPath();
        StringBuilder builder = SharedStringBuilder.get(context, VIEW_HANDLER_SUPPORT_SB);
        if (contextPath != null && (contextPath.length() != 1 || contextPath.charAt(0) != '/')) {
            builder.append(contextPath);
        }
        if (mapping != null && mapping.isExactMapping() && (exactMappingViewId = this.calculatePrefixedExactMapping(context, viewId)) != null && !exactMappingViewId.isEmpty() && !mapping.getExact().equals(exactMappingViewId) && (mapping = FacesServletMappingUtils.getExactMapping(context, exactMappingViewId)) == null && (mapping = FacesServletMappingUtils.getGenericPrefixOrSuffixMapping(context)) == null) {
            throw new IllegalStateException("No generic (either prefix or suffix) servlet-mapping found for FacesServlet.This is required serve views, that are not exact mapped.");
        }
        if (mapping != null) {
            if (mapping.isExactMapping()) {
                builder.append(mapping.getExact());
            } else if (mapping.isExtensionMapping()) {
                String[] contextSuffixes = this._initialized ? this._contextSuffixes : this.getContextSuffix(context);
                boolean founded = false;
                for (String contextSuffix : contextSuffixes) {
                    if (!viewId.endsWith(contextSuffix)) continue;
                    builder.append(viewId.substring(0, viewId.indexOf(contextSuffix)));
                    builder.append(mapping.getExtension());
                    founded = true;
                    break;
                }
                if (!founded) {
                    if (viewId.endsWith(mapping.getExtension())) {
                        builder.append(viewId);
                    } else if (viewId.lastIndexOf(46) != -1) {
                        builder.append(viewId.substring(0, viewId.lastIndexOf(46)));
                        builder.append(contextSuffixes[0]);
                    } else {
                        builder.append(viewId);
                        builder.append(contextSuffixes[0]);
                    }
                }
            } else if (mapping.isPrefixMapping()) {
                builder.append(mapping.getPrefix());
                builder.append(viewId);
            }
        } else {
            builder.append(viewId);
        }
        if (ViewProtectionUtils.isViewProtected(context, viewId)) {
            int index = builder.indexOf("?");
            if (index >= 0) {
                builder.append("&");
            } else {
                builder.append("?");
            }
            builder.append("jakarta.faces.Token");
            builder.append("=");
            ResponseStateManager rsm = context.getRenderKit().getResponseStateManager();
            builder.append(rsm.getCryptographicallyStrongTokenFromSession(context));
        }
        String calculatedActionURL = builder.toString();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Calculated actionURL: '" + calculatedActionURL + "' for viewId: '" + viewId + "'");
        }
        return calculatedActionURL;
    }

    private String calculatePrefixedExactMapping(FacesContext context, String viewId) {
        String[] contextSuffixes = this._initialized ? this._contextSuffixes : this.getContextSuffix(context);
        String prefixedExactMapping = null;
        for (String contextSuffix : contextSuffixes) {
            if (!viewId.endsWith(contextSuffix)) continue;
            prefixedExactMapping = viewId.substring(0, viewId.length() - contextSuffix.length());
            break;
        }
        return prefixedExactMapping == null ? viewId : prefixedExactMapping;
    }

    protected FacesServletMapping getFacesServletMapping(FacesContext context) {
        Map attributes = context.getAttributes();
        FacesServletMapping mapping = (FacesServletMapping)attributes.get(CACHED_SERVLET_MAPPING);
        if (mapping == null) {
            ExternalContext externalContext = context.getExternalContext();
            mapping = FacesServletMappingUtils.calculateFacesServletMapping(context, externalContext.getRequestServletPath(), externalContext.getRequestPathInfo(), true);
            attributes.put(CACHED_SERVLET_MAPPING, mapping);
        }
        return mapping;
    }

    protected String[] getContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("jakarta.faces.DEFAULT_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml .view.xml .jsp";
        }
        return StringUtils.splitShortString(defaultSuffix, ' ');
    }

    protected String getFaceletsContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("jakarta.faces.FACELETS_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml";
        }
        return defaultSuffix;
    }

    protected String[] getFaceletsViewMappings(FacesContext context) {
        String faceletsViewMappings = context.getExternalContext().getInitParameter("jakarta.faces.FACELETS_VIEW_MAPPINGS");
        if (faceletsViewMappings == null) {
            faceletsViewMappings = context.getExternalContext().getInitParameter("facelets.VIEW_MAPPINGS");
        }
        return faceletsViewMappings == null ? null : StringUtils.splitShortString(faceletsViewMappings, ';');
    }

    protected String handlePrefixMapping(String viewId, String prefix) {
        prefix = "".equals(prefix) ? "//" : prefix + '/';
        String uri = viewId;
        while (uri.startsWith(prefix) || uri.startsWith("//")) {
            if (uri.startsWith(prefix)) {
                uri = uri.substring(prefix.length() - 1);
                continue;
            }
            uri = uri.substring(1);
        }
        return uri;
    }

    protected String handleSuffixMapping(FacesContext context, String requestViewId) {
        String faceletsDefaultSuffix;
        String[] faceletsViewMappings = this._initialized ? this._faceletsViewMappings : this.getFaceletsViewMappings(context);
        String[] jspDefaultSuffixes = this._initialized ? this._contextSuffixes : this.getContextSuffix(context);
        int slashPos = requestViewId.lastIndexOf(47);
        int extensionPos = requestViewId.lastIndexOf(46);
        StringBuilder builder = SharedStringBuilder.get(context, VIEW_HANDLER_SUPPORT_SB);
        for (String defaultSuffix : jspDefaultSuffixes) {
            builder.setLength(0);
            builder.append(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), defaultSuffix);
            } else {
                builder.append(defaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (faceletsViewMappings != null && faceletsViewMappings.length > 0) {
                for (String mapping : faceletsViewMappings) {
                    if (mapping.startsWith("/")) continue;
                    if (mapping.equals(candidateViewId)) {
                        return candidateViewId;
                    }
                    if (!mapping.startsWith(".")) continue;
                    builder.setLength(0);
                    builder.append(candidateViewId);
                    builder.replace(candidateViewId.lastIndexOf(46), candidateViewId.length(), mapping);
                    String tempViewId = builder.toString();
                    if (!this.checkResourceExists(context, tempViewId)) continue;
                    return tempViewId;
                }
            }
            if (!this.checkResourceExists(context, candidateViewId)) continue;
            return candidateViewId;
        }
        String string = faceletsDefaultSuffix = this._initialized ? this._faceletsContextSufix : this.getFaceletsContextSuffix(context);
        if (faceletsDefaultSuffix != null) {
            for (String defaultSuffix : jspDefaultSuffixes) {
                if (!faceletsDefaultSuffix.equals(defaultSuffix)) continue;
                faceletsDefaultSuffix = null;
                break;
            }
        }
        if (faceletsDefaultSuffix != null) {
            builder.setLength(0);
            builder.append(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), faceletsDefaultSuffix);
            } else {
                builder.append(faceletsDefaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (this.checkResourceExists(context, candidateViewId)) {
                return candidateViewId;
            }
        }
        if (this.checkResourceExists(context, requestViewId)) {
            return requestViewId;
        }
        return null;
    }

    protected boolean checkResourceExists(FacesContext facesContext, String viewId) {
        if (this.checkedViewIdsCache == null) {
            this.checkedViewIdsCache = CheckedViewIdsCache.getInstance(facesContext);
        }
        try {
            Boolean resourceExists = null;
            if (this.checkedViewIdsCache.isEnabled()) {
                resourceExists = this.checkedViewIdsCache.getCache().get(viewId);
            }
            if (resourceExists == null) {
                ViewDeclarationLanguage vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, viewId);
                resourceExists = vdl != null ? Boolean.valueOf(vdl.viewExists(facesContext, viewId)) : Boolean.valueOf(facesContext.getExternalContext().getResource(viewId) != null);
                if (this.checkedViewIdsCache.isEnabled()) {
                    this.checkedViewIdsCache.getCache().put(viewId, resourceExists);
                }
            }
            return resourceExists;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }
}

