/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentPropertyDescriptor;

public class InsertFacetHandler
extends TagHandler {
    public static final String INSERT_FACET_USED = "org.apache.myfaces.INSERT_FACET_USED";
    public static final String INSERT_FACET_KEYS = "org.apache.myfaces.INSERT_FACET_KEYS";
    private static final Logger log = Logger.getLogger(InsertFacetHandler.class.getName());
    protected final TagAttribute _name = this.getRequiredAttribute("name");
    protected final TagAttribute _required = this.getAttribute("required");

    public InsertFacetHandler(TagConfig config) {
        super(config);
    }

    public String getFacetName(FaceletContext ctx) {
        return this._name.getValue(ctx);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (((AbstractFaceletContext)ctx).isBuildingCompositeComponentMetadata()) {
            String facetName = this._name.getValue(ctx);
            UIComponent compositeBaseParent = FaceletCompositionContext.getCurrentInstance(ctx).getCompositeComponentFromStack();
            CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)compositeBaseParent.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
            if (beanInfo == null) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.severe("Cannot find composite bean descriptor UIComponent.BEANINFO_KEY ");
                }
                return;
            }
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            ArrayList<String> facetList = (ArrayList<String>)beanDescriptor.getValue(INSERT_FACET_USED);
            if (facetList == null) {
                facetList = new ArrayList<String>(5);
                beanDescriptor.setValue(INSERT_FACET_USED, facetList);
            }
            facetList.add(facetName);
            HashMap<String, PropertyDescriptor> insertFacetPropertyDescriptorMap = (HashMap<String, PropertyDescriptor>)beanDescriptor.getValue(INSERT_FACET_KEYS);
            if (insertFacetPropertyDescriptorMap == null) {
                insertFacetPropertyDescriptorMap = new HashMap<String, PropertyDescriptor>(5);
                beanDescriptor.setValue(INSERT_FACET_KEYS, insertFacetPropertyDescriptorMap);
            }
            PropertyDescriptor facetDescriptor = this._createFacetPropertyDescriptor(facetName, ctx);
            insertFacetPropertyDescriptorMap.put(facetName, facetDescriptor);
        } else {
            String facetName = this._name.getValue(ctx);
            AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
            actx.includeCompositeComponentDefinition(parent, facetName);
        }
    }

    private PropertyDescriptor _createFacetPropertyDescriptor(String facetName, FaceletContext ctx) throws TagException, IOException {
        try {
            CompositeComponentPropertyDescriptor facetPropertyDescriptor = new CompositeComponentPropertyDescriptor(facetName);
            if (this._required != null) {
                facetPropertyDescriptor.setValue("required", this._required.getValueExpression(ctx, Boolean.class));
            }
            return facetPropertyDescriptor;
        }
        catch (IntrospectionException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "Cannot create PropertyDescriptor for attribute ", e);
            }
            throw new TagException(this.tag, (Throwable)e);
        }
    }
}

