/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.FacesException;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.component.behavior.FacesBehavior;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.convert.FacesConverter;
import jakarta.faces.event.NamedEvent;
import jakarta.faces.render.FacesBehaviorRenderer;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.validator.FacesValidator;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.config.annotation.CdiAnnotationProviderExtension;
import org.apache.myfaces.config.annotation.ClassByteCodeAnnotationFilter;
import org.apache.myfaces.config.annotation.PackageInfo;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.spi.AnnotationProvider;
import org.apache.myfaces.spi.AnnotationProviderFactory;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.view.facelets.util.Classpath;

public class DefaultAnnotationProvider
extends AnnotationProvider {
    private static final Logger log = Logger.getLogger(DefaultAnnotationProvider.class.getName());
    private static final String WEB_CLASSES_PREFIX = "/WEB-INF/classes/";
    private static final String WEB_LIB_PREFIX = "/WEB-INF/lib/";
    private static final String META_INF_PREFIX = "META-INF/";
    private static final String FACES_CONFIG_SUFFIX = ".faces-config.xml";
    private static final String FACES_CONFIG_IMPLICIT = "META-INF/faces-config.xml";
    private static final Set<String> JSF_ANNOTATION_NAMES;
    private static final Set<Class<? extends Annotation>> JSF_ANNOTATION_CLASSES;

    @Override
    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(ExternalContext ctx) {
        BeanManager beanManager;
        CdiAnnotationProviderExtension extension;
        if (MyfacesConfig.getCurrentInstance(ctx).isUseCdiForAnnotationScanning() && (extension = CDIUtils.getOptional(beanManager = CDIUtils.getBeanManager(ctx), CdiAnnotationProviderExtension.class)) != null) {
            return extension.getMap();
        }
        HashMap map = new HashMap();
        Collection<Class<?>> classes = null;
        try {
            classes = this.getAnnotatedWebInfClasses(ctx);
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        for (Class<?> clazz : classes) {
            this.processClass(map, clazz);
        }
        try {
            AnnotationProvider provider = AnnotationProviderFactory.getAnnotationProviderFactory(ctx).getAnnotationProvider(ctx);
            classes = this.getAnnotatedMetaInfClasses(ctx, provider.getBaseUrls(ctx));
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        for (Class<?> clazz : classes) {
            this.processClass(map, clazz);
        }
        return map;
    }

    @Override
    public Set<URL> getBaseUrls(ExternalContext context) throws IOException {
        ClassLoader cl = ClassUtils.getCurrentLoader(this);
        HashSet<URL> urlSet = new HashSet<URL>();
        Enumeration<URL> resources = cl.getResources(FACES_CONFIG_IMPLICIT);
        while (resources.hasMoreElements()) {
            urlSet.add(resources.nextElement());
        }
        URL[] urls = Classpath.search(cl, META_INF_PREFIX, FACES_CONFIG_SUFFIX);
        Collections.addAll(urlSet, urls);
        return urlSet;
    }

    protected Collection<Class<?>> getAnnotatedMetaInfClasses(ExternalContext ctx, Set<URL> urls) {
        if (urls != null && !urls.isEmpty()) {
            ArrayList list = new ArrayList();
            for (URL url : urls) {
                try {
                    JarFile jarFile = this.getJarFile(url);
                    if (jarFile == null) continue;
                    this.archiveClasses(jarFile, list);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "cannot scan jar file for annotations:" + String.valueOf(url), e);
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    protected Collection<Class<?>> getAnnotatedWebInfClasses(ExternalContext ctx) throws IOException {
        String scanPackages = MyfacesConfig.getCurrentInstance(ctx).getScanPackages();
        if (scanPackages != null) {
            try {
                return this.packageClasses(ctx, scanPackages);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new FacesException(e);
            }
        }
        return this.webClasses(ctx);
    }

    private List<Class<?>> packageClasses(ExternalContext externalContext, String scanPackages) throws ClassNotFoundException, IOException {
        String[] scanPackageTokens;
        ArrayList list = new ArrayList();
        for (String scanPackageToken : scanPackageTokens = scanPackages.split(",")) {
            Class[] classes;
            if (scanPackageToken.toLowerCase().endsWith(".jar")) {
                URL jarResource = externalContext.getResource(WEB_LIB_PREFIX + scanPackageToken);
                String jarURLString = "jar:" + jarResource.toString() + "!/";
                URL url = new URL(jarURLString);
                JarFile jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                this.archiveClasses(jarFile, list);
                continue;
            }
            for (Class c : classes = PackageInfo.getClasses(scanPackageToken)) {
                list.add(c);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class<?>> archiveClasses(JarFile jar, List<Class<?>> list) {
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || (name = entry.getName()).startsWith(META_INF_PREFIX) || !name.endsWith(".class")) continue;
            DataInputStream in = null;
            boolean couldContainAnnotation = false;
            try {
                in = new DataInputStream(jar.getInputStream(entry));
                couldContainAnnotation = ClassByteCodeAnnotationFilter.couldContainAnnotationsOnClassDef(in, JSF_ANNOTATION_NAMES);
            }
            catch (IOException e) {
                couldContainAnnotation = true;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("IOException when filtering class " + name + " for annotations");
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (!couldContainAnnotation) continue;
            name = name.substring(0, name.length() - 6);
            Class<?> clazz = null;
            try {
                clazz = loader.loadClass(name.replace('/', '.'));
            }
            catch (Exception | NoClassDefFoundError throwable) {
                // empty catch block
            }
            if (clazz == null) continue;
            list.add(clazz);
        }
        return list;
    }

    private List<Class<?>> webClasses(ExternalContext externalContext) {
        ArrayList list = new ArrayList();
        this.webClasses(externalContext, WEB_CLASSES_PREFIX, list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void webClasses(ExternalContext externalContext, String prefix, List<Class<?>> list) {
        ClassLoader loader = ClassUtils.getCurrentLoader(this);
        Set<String> paths = externalContext.getResourcePaths(prefix);
        if (paths == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("webClasses(" + prefix + ") - Received " + paths.size() + " paths to check");
        }
        String path = null;
        if (paths.isEmpty()) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("AnnotationConfigurator does not found classes for annotations in " + prefix + " . This could happen because maven jetty plugin is used (goal jetty:run). Try configure org.apache.myfaces.annotation.SCAN_PACKAGES init parameter or use jetty:run-exploded instead.");
            }
        } else {
            for (String pathObject : paths) {
                path = pathObject;
                if (path.endsWith("/")) {
                    this.webClasses(externalContext, path, list);
                    continue;
                }
                if (!path.endsWith(".class")) continue;
                DataInputStream in = null;
                boolean couldContainAnnotation = false;
                try {
                    in = new DataInputStream(externalContext.getResourceAsStream(path));
                    couldContainAnnotation = ClassByteCodeAnnotationFilter.couldContainAnnotationsOnClassDef(in, JSF_ANNOTATION_NAMES);
                }
                catch (IOException e) {
                    couldContainAnnotation = true;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("IOException when filtering class " + path + " for annotations");
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (!couldContainAnnotation) continue;
                path = path.substring(WEB_CLASSES_PREFIX.length());
                path = path.substring(0, path.length() - 6);
                path = path.replace('/', '.');
                Class<?> clazz = null;
                try {
                    clazz = loader.loadClass(path);
                }
                catch (Exception | NoClassDefFoundError throwable) {
                    // empty catch block
                }
                if (clazz == null) continue;
                list.add(clazz);
            }
        }
    }

    private JarFile getJarFile(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setUseCaches(false);
        conn.setDefaultUseCaches(false);
        JarFile jarFile = conn instanceof JarURLConnection ? ((JarURLConnection)conn).getJarFile() : DefaultAnnotationProvider._getAlternativeJarFile(url);
        return jarFile;
    }

    private static JarFile _getAlternativeJarFile(URL url) throws IOException {
        String urlFile = url.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex == -1) {
            separatorIndex = urlFile.indexOf(33);
        }
        if (separatorIndex != -1) {
            String jarFileUrl = urlFile.substring(0, separatorIndex);
            if (jarFileUrl.startsWith("file:")) {
                jarFileUrl = jarFileUrl.substring("file:".length());
            }
            return new JarFile(jarFileUrl);
        }
        return null;
    }

    private void processClass(Map<Class<? extends Annotation>, Set<Class<?>>> map, Class<?> clazz) {
        Annotation[] annotations;
        for (Annotation anno : annotations = clazz.getAnnotations()) {
            Class<? extends Annotation> annotationClass = anno.annotationType();
            if (!JSF_ANNOTATION_CLASSES.contains(annotationClass)) continue;
            Set set = map.computeIfAbsent(annotationClass, k -> new HashSet());
            set.add(clazz);
        }
    }

    static {
        HashSet<String> bcan = new HashSet<String>(10, 1.0f);
        bcan.add("Ljakarta/faces/component/FacesComponent;");
        bcan.add("Ljakarta/faces/component/behavior/FacesBehavior;");
        bcan.add("Ljakarta/faces/convert/FacesConverter;");
        bcan.add("Ljakarta/faces/validator/FacesValidator;");
        bcan.add("Ljakarta/faces/render/FacesRenderer;");
        bcan.add("Ljakarta/faces/event/NamedEvent;");
        bcan.add("Ljakarta/faces/render/FacesBehaviorRenderer;");
        JSF_ANNOTATION_NAMES = Collections.unmodifiableSet(bcan);
        HashSet<Class<FacesBehaviorRenderer>> ancl = new HashSet<Class<FacesBehaviorRenderer>>(10, 1.0f);
        ancl.add(FacesComponent.class);
        ancl.add(FacesBehavior.class);
        ancl.add(FacesConverter.class);
        ancl.add(FacesValidator.class);
        ancl.add(FacesRenderer.class);
        ancl.add(NamedEvent.class);
        ancl.add(FacesBehaviorRenderer.class);
        JSF_ANNOTATION_CLASSES = Collections.unmodifiableSet(ancl);
    }
}

