/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.weld.startup;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.myfaces.extensions.cdi.core.api.InvocationOrder;
import org.apache.myfaces.extensions.cdi.core.api.activation.Deactivatable;
import org.apache.myfaces.extensions.cdi.core.api.startup.event.StartupEventBroadcaster;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;
import org.jboss.weld.environment.servlet.Listener;

@InvocationOrder(value=1)
public class WeldAwareConfigurationListener
extends Listener
implements StartupEventBroadcaster,
Deactivatable {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected static Map<ClassLoader, Boolean> initialized = new ConcurrentHashMap<ClassLoader, Boolean>();

    public void contextInitialized(ServletContextEvent event) {
        if (!this.isInitialized()) {
            this.logger.info("Controlled Weld bootstrapping.");
            super.contextInitialized(event);
            this.markAsInitialized();
        }
    }

    public void broadcastStartup() {
        if (!this.isActivated()) {
            return;
        }
        if (this.isInitialized()) {
            return;
        }
        this.logger.info("Controlled MyFaces ExtCDI bootstrapping.");
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && facesContext.getExternalContext() != null) {
            ServletContext servletContext = (ServletContext)facesContext.getExternalContext().getContext();
            this.contextInitialized(new ServletContextEvent(servletContext));
        }
        this.markAsInitialized();
    }

    protected void markAsInitialized() {
        initialized.put(this.getClassLoader(), Boolean.TRUE);
    }

    protected boolean isInitialized() {
        ClassLoader classLoader = this.getClassLoader();
        return Boolean.TRUE.equals(initialized.get(classLoader));
    }

    private ClassLoader getClassLoader() {
        return ClassUtils.getClassLoader(null);
    }

    public boolean isActivated() {
        return ClassDeactivation.isClassActivated(((Object)((Object)this)).getClass());
    }
}

