/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.scripting.impl.util;

import java.util.Map;
import javax.enterprise.inject.Typed;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.myfaces.extensions.cdi.core.api.UnhandledException;
import org.apache.myfaces.extensions.cdi.core.impl.util.UnmodifiableMap;
import org.apache.myfaces.extensions.cdi.scripting.impl.spi.ExternalExpressionInterpreter;
import org.apache.myfaces.extensions.cdi.scripting.impl.util.ArgumentAwareScriptHelperMap;
import org.apache.myfaces.extensions.cdi.scripting.impl.util.ScriptingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
class ScriptHelperMap
extends UnmodifiableMap<String, Object> {
    private static final long serialVersionUID = 393871900655666197L;
    private String language;

    protected ScriptHelperMap() {
    }

    ScriptHelperMap(String language) {
        this.language = language;
    }

    public Object get(Object key) {
        String argumentsOrScript = key instanceof String ? (String)key : key.toString();
        if (argumentsOrScript.startsWith("[") && argumentsOrScript.endsWith("]")) {
            return new ArgumentAwareScriptHelperMap(this.language, argumentsOrScript);
        }
        return this.evalScript(this.language, argumentsOrScript, null);
    }

    protected Object evalScript(String language, String script, Map<String, Object> arguments) {
        try {
            script = this.interpreteScript(script);
            SimpleBindings bindings = null;
            if (arguments != null) {
                bindings = new SimpleBindings(arguments);
            }
            if (bindings != null) {
                return ScriptingUtils.getCurrentScriptEngineManager().getEngineByName(language).eval(script, (Bindings)bindings);
            }
            return ScriptingUtils.getCurrentScriptEngineManager().getEngineByName(language).eval(script);
        }
        catch (ScriptException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private String interpreteScript(String script) {
        ExternalExpressionInterpreter externalExpressionInterpreter = ScriptingUtils.resolveExternalExpressionInterpreter();
        return externalExpressionInterpreter.transform(script);
    }
}

