/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Named;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.ConversationGroup;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.event.UnscopeBeanEvent;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.BeanEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeanStorage
implements Serializable {
    private static final long serialVersionUID = 7020160538290030954L;
    private BeanManager beanManager;
    private ConcurrentHashMap<Class, BeanEntry<Serializable>> beanMap = new ConcurrentHashMap();

    BeanStorage(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    BeanEntry getBean(Class beanClass) {
        return this.beanMap.get(beanClass);
    }

    <T> Set<Class<T>> getBeanSubGroup(Class<T> key) {
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        for (Class beanClass : this.beanMap.keySet()) {
            if (!key.isAssignableFrom(beanClass)) continue;
            result.add(beanClass);
        }
        return result;
    }

    BeanEntry addBean(BeanEntry<Serializable> beanEntry) {
        Class beanClass = beanEntry.getBean().getBeanClass();
        this.beanMap.remove(beanClass);
        this.beanMap.put(beanClass, beanEntry);
        return beanEntry;
    }

    BeanEntry<Serializable> removeBean(Class<Serializable> beanClass) {
        BeanEntry<Serializable> beanEntryToRemove = this.beanMap.remove(beanClass);
        this.removeBeanEntry(beanEntryToRemove);
        return beanEntryToRemove;
    }

    void resetStorage() {
        for (BeanEntry<Serializable> beanEntry : this.beanMap.values()) {
            this.removeBeanEntry(beanEntry);
        }
    }

    private void removeBeanEntry(BeanEntry<Serializable> beanEntry) {
        Serializable oldBeanInstance = (Serializable)beanEntry.resetBeanInstance();
        if (beanEntry.isUnscopeBeanEventEnabled()) {
            this.fireUnscopeBeanEvent(oldBeanInstance);
        }
        beanEntry.getBean().destroy((Object)oldBeanInstance, beanEntry.getCreationalContext());
    }

    private <T extends Serializable> void fireUnscopeBeanEvent(T instance) {
        this.beanManager.fireEvent((Object)new UnscopeBeanEvent(instance), new Annotation[0]);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.beanMap.size());
        result.append(" beans:\n");
        for (BeanEntry<Serializable> beanEntry : this.beanMap.values()) {
            Bean bean = beanEntry.getBean();
            result.append("\t[bean]\n");
            result.append("\tbean-class:\t\t\t\t");
            result.append(bean.getBeanClass());
            result.append("\n\tcustom qualifier types: ");
            boolean customQualifierFound = false;
            for (Annotation qualifier : bean.getQualifiers()) {
                Class<? extends Annotation> qualifierType = qualifier.annotationType();
                if (ConversationGroup.class.equals(qualifierType) || Any.class.equals(qualifierType) || Default.class.equals(qualifierType) || Named.class.equals(qualifierType)) continue;
                result.append("\t");
                result.append(qualifier.annotationType().getName());
                result.append("\n");
                customQualifierFound = true;
            }
            if (customQualifierFound) continue;
            result.append("---\n");
        }
        result.append("\n*******");
        return result.toString();
    }
}

