/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.metadata.transformer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.Nested;
import org.apache.myfaces.extensions.validator.core.factory.AbstractNameMapperAwareFactory;
import org.apache.myfaces.extensions.validator.core.factory.ClassMappingFactory;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfiguration;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfigurationEntry;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfigurationNames;
import org.apache.myfaces.extensions.validator.core.mapper.NameMapper;
import org.apache.myfaces.extensions.validator.core.mapper.SubMapperAwareNameMapper;
import org.apache.myfaces.extensions.validator.core.metadata.transformer.MetaDataTransformer;
import org.apache.myfaces.extensions.validator.core.metadata.transformer.SortedNameMapperList;
import org.apache.myfaces.extensions.validator.core.metadata.transformer.mapper.ValidationStrategyToMetaDataTransformerSubMapperAwareNameMapper;
import org.apache.myfaces.extensions.validator.core.validation.strategy.BeanValidationStrategyAdapter;
import org.apache.myfaces.extensions.validator.core.validation.strategy.IdentifiableValidationStrategy;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;
import org.apache.myfaces.extensions.validator.util.NullValueAwareConcurrentHashMap;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL, UsageCategory.CUSTOMIZABLE})
public class DefaultMetaDataTransformerFactory
extends AbstractNameMapperAwareFactory<ValidationStrategy>
implements ClassMappingFactory<ValidationStrategy, MetaDataTransformer> {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private Map<String, String> validationStrategyToMetaDataTransformerMapping;
    private List<NameMapper<ValidationStrategy>> nameMapperList = new CopyOnWriteArrayList<NameMapper<ValidationStrategy>>();
    private List<NameMapper<ValidationStrategy>> subNameMapperList = new CopyOnWriteArrayList<NameMapper<ValidationStrategy>>();

    public DefaultMetaDataTransformerFactory() {
        this.logger.fine(this.getClass().getName() + " instantiated");
        this.register(new ValidationStrategyToMetaDataTransformerSubMapperAwareNameMapper());
    }

    @Override
    public MetaDataTransformer create(ValidationStrategy validationStrategy) {
        String validationStrategyName = this.createValidationStrategyName(validationStrategy);
        this.tryToInitStaticMappings();
        MetaDataTransformer metaDataTransformer = this.tryToResolveCachedMetaDataTransformer(validationStrategy, validationStrategyName);
        if (metaDataTransformer != null) {
            return metaDataTransformer;
        }
        return this.createAndCacheMetaDataTransformer(validationStrategy, validationStrategyName);
    }

    private String createValidationStrategyName(ValidationStrategy validationStrategy) {
        boolean isProxyDetected = this.isProxy(validationStrategy);
        if (isProxyDetected && validationStrategy instanceof BeanValidationStrategyAdapter) {
            return ((BeanValidationStrategyAdapter)validationStrategy).getValidationStrategyClassName();
        }
        return !isProxyDetected ? ProxyUtils.getClassName(validationStrategy.getClass()) : null;
    }

    private void tryToInitStaticMappings() {
        if (this.validationStrategyToMetaDataTransformerMapping == null) {
            this.initStaticMappings();
        }
    }

    private boolean isProxy(ValidationStrategy validationStrategy) {
        return validationStrategy.getClass().getPackage() == null;
    }

    private MetaDataTransformer createAndCacheMetaDataTransformer(ValidationStrategy validationStrategy, String validationStrategyName) {
        for (NameMapper<ValidationStrategy> nameMapper : this.nameMapperList) {
            MetaDataTransformer metaDataTransformer;
            String transformerName = nameMapper.createName(validationStrategy);
            if (transformerName == null || (metaDataTransformer = this.tryToCreateAndCacheMetaDataTransformer(validationStrategy, validationStrategyName, transformerName)) == null) continue;
            return metaDataTransformer;
        }
        return this.tryToCreateAndCacheMetaDataTransformer(validationStrategy, validationStrategyName, null);
    }

    private MetaDataTransformer tryToResolveCachedMetaDataTransformer(ValidationStrategy validationStrategy, String validationStrategyName) {
        String newValidationStrategyName;
        if (this.validationStrategyToMetaDataTransformerMapping.containsKey(validationStrategyName)) {
            return (MetaDataTransformer)ClassUtils.tryToInstantiateClassForName(this.validationStrategyToMetaDataTransformerMapping.get(validationStrategyName));
        }
        if (validationStrategy instanceof IdentifiableValidationStrategy && this.validationStrategyToMetaDataTransformerMapping.containsKey(newValidationStrategyName = validationStrategyName + ":" + ((IdentifiableValidationStrategy)validationStrategy).getId())) {
            return (MetaDataTransformer)ClassUtils.tryToInstantiateClassForName(this.validationStrategyToMetaDataTransformerMapping.get(newValidationStrategyName));
        }
        return null;
    }

    private MetaDataTransformer tryToCreateAndCacheMetaDataTransformer(ValidationStrategy validationStrategy, String validationStrategyName, String transformerName) {
        MetaDataTransformer metaDataTransformer = null;
        if (transformerName != null) {
            metaDataTransformer = (MetaDataTransformer)ClassUtils.tryToInstantiateClassForName(transformerName);
        }
        if (validationStrategyName != null) {
            if (validationStrategy instanceof IdentifiableValidationStrategy) {
                validationStrategyName = validationStrategyName + ":" + ((IdentifiableValidationStrategy)validationStrategy).getId();
            }
            this.addMapping(validationStrategyName, transformerName);
        }
        return metaDataTransformer;
    }

    private synchronized void initStaticMappings() {
        this.validationStrategyToMetaDataTransformerMapping = new NullValueAwareConcurrentHashMap<String, String>(String.class);
        for (StaticConfiguration<String, String> staticConfig : ExtValContext.getContext().getStaticConfiguration(StaticConfigurationNames.VALIDATION_STRATEGY_TO_META_DATA_TRANSFORMER_CONFIG)) {
            this.setupMappings(staticConfig.getMapping());
        }
    }

    private void setupMappings(List<StaticConfigurationEntry<String, String>> mappings) {
        for (StaticConfigurationEntry<String, String> mapping : mappings) {
            this.addMapping(mapping.getSource(), mapping.getTarget());
        }
    }

    private synchronized void addMapping(String validationStrategyName, String transformerName) {
        this.logger.finest("adding validation strategy to meta-data transformer mapping: " + validationStrategyName + " -> " + transformerName);
        this.validationStrategyToMetaDataTransformerMapping.put(validationStrategyName, transformerName);
    }

    @Override
    protected List<NameMapper<ValidationStrategy>> getNameMapperList() {
        return new SortedNameMapperList<NameMapper<ValidationStrategy>>(this.nameMapperList, this.subNameMapperList);
    }

    @Override
    public void register(NameMapper<ValidationStrategy> validationStrategyNameMapper) {
        this.tryToInitNameMapperWithExistingSubMappers(validationStrategyNameMapper);
        super.register(validationStrategyNameMapper);
    }

    @Override
    public void deregister(Class<? extends NameMapper> classToDeregister) {
        super.deregister(classToDeregister);
        for (NameMapper<ValidationStrategy> nameMapper : new ArrayList<NameMapper<ValidationStrategy>>(this.subNameMapperList)) {
            if (!nameMapper.getClass().equals(classToDeregister)) continue;
            this.subNameMapperList.remove(nameMapper);
        }
    }

    private void tryToInitNameMapperWithExistingSubMappers(NameMapper<ValidationStrategy> validationStrategyNameMapper) {
        if (validationStrategyNameMapper instanceof SubMapperAwareNameMapper) {
            for (NameMapper<ValidationStrategy> nameMapper : this.subNameMapperList) {
                if (!nameMapper.getClass().isAnnotationPresent(Nested.class)) continue;
                ((SubMapperAwareNameMapper)validationStrategyNameMapper).addNameMapper(nameMapper);
            }
        }
    }

    protected List<NameMapper<ValidationStrategy>> getSubNameMapperList() {
        return this.subNameMapperList;
    }
}

