/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.el.CompositeComponentExpressionHolder;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class ExtValELResolver
extends ELResolver {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private ELResolver wrapped;
    private boolean projectStageDevelopment;
    private Object baseObject;
    private String property;
    private String expression;
    private boolean isPathRecordingStopped = false;
    private CompositeComponentExpressionHolder compositeComponentExpressionHolder;
    private String compositeComponentExpressionBase;

    public ExtValELResolver(ELResolver elResolver, boolean projectStageDevelopment) {
        this.wrapped = elResolver;
        this.projectStageDevelopment = projectStageDevelopment;
    }

    public Object getBaseObject() {
        return this.baseObject;
    }

    public String getProperty() {
        return this.property;
    }

    public String getPath() {
        this.logger.finest("extracted path: " + this.expression);
        return this.expression;
    }

    public void reset() {
        this.baseObject = null;
        this.property = null;
        this.expression = null;
    }

    public Object getValue(ELContext elContext, Object base, Object property) {
        Object result = this.wrapped.getValue(elContext, base, property);
        if (this.compositeComponentExpressionHolder != null && this.compositeComponentExpressionBase == null) {
            this.compositeComponentExpressionBase = (String)property;
        }
        if (this.compositeComponentExpressionHolder == null && result instanceof CompositeComponentExpressionHolder) {
            this.compositeComponentExpressionHolder = (CompositeComponentExpressionHolder)result;
        }
        if (this.expression == null) {
            this.expression = (String)property;
        } else if (base == null) {
            this.isPathRecordingStopped = true;
        } else {
            boolean propertyExists = false;
            String propertyName = property.toString();
            propertyName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            try {
                if (base instanceof Map) {
                    if (((Map)base).containsKey(property)) {
                        propertyExists = true;
                    }
                } else if (ProxyUtils.getUnproxiedClass(base.getClass()).getMethod("get" + propertyName, new Class[0]) != null) {
                    propertyExists = true;
                }
            }
            catch (NoSuchMethodException e) {
                try {
                    if (ProxyUtils.getUnproxiedClass(base.getClass()).getMethod("is" + propertyName, new Class[0]) != null) {
                        propertyExists = true;
                    }
                }
                catch (NoSuchMethodException e1) {
                    if (!"attrs".equals(property)) {
                        this.logger.finest("property: " + property + " isn't used for path - it isn't a property of " + base.getClass());
                    }
                }
            }
            catch (Throwable t) {
                return result;
            }
            if (propertyExists && !this.isPathRecordingStopped) {
                this.expression = this.expression + "." + property;
            } else if (propertyExists && result instanceof String) {
                this.isPathRecordingStopped = false;
            }
        }
        return result;
    }

    public Class<?> getType(ELContext elContext, Object o, Object o1) {
        return this.wrapped.getType(elContext, o, o1);
    }

    public void setValue(ELContext elContext, Object o, Object o1, Object o2) {
        if (o1 instanceof String) {
            this.expression = this.expression == null ? (String)o1 : this.expression + "." + o1;
            this.property = (String)o1;
        }
        this.baseObject = o;
        elContext.setPropertyResolved(true);
    }

    public boolean isReadOnly(ELContext elContext, Object o, Object o1) {
        return this.wrapped.isReadOnly(elContext, o, o1);
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, Object o) {
        return this.wrapped.getFeatureDescriptors(elContext, o);
    }

    public Class<?> getCommonPropertyType(ELContext elContext, Object o) {
        return this.wrapped.getCommonPropertyType(elContext, o);
    }

    public static ELContext createContextWrapper(final ELContext context, final ELResolver resolver) {
        return new ELContext(){

            public Locale getLocale() {
                return context.getLocale();
            }

            public void setPropertyResolved(boolean value) {
                super.setPropertyResolved(value);
                context.setPropertyResolved(value);
            }

            public void putContext(Class clazz, Object object) {
                super.putContext(clazz, object);
                context.putContext(clazz, object);
            }

            public Object getContext(Class clazz) {
                return context.getContext(clazz);
            }

            public void setLocale(Locale locale) {
                super.setLocale(locale);
                context.setLocale(locale);
            }

            public ELResolver getELResolver() {
                return resolver;
            }

            public FunctionMapper getFunctionMapper() {
                return context.getFunctionMapper();
            }

            public VariableMapper getVariableMapper() {
                return context.getVariableMapper();
            }
        };
    }

    public ValueExpression getCompositeComponentExpression() {
        if (this.compositeComponentExpressionHolder != null) {
            return this.compositeComponentExpressionHolder.getExpression(this.compositeComponentExpressionBase);
        }
        return null;
    }
}

