/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.validation.strategy;

import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.validation.exception.RequiredValidatorException;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

@UsageInformation(value={UsageCategory.INTERNAL, UsageCategory.REUSE})
public abstract class AbstractValidationStrategy
implements ValidationStrategy {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    protected AbstractValidationStrategy() {
        this.logger.fine(this.getClass().getName() + " instantiated");
    }

    public void validate(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject) {
        this.logger.finest("start initValidation of " + this.getClass().getName());
        this.initValidation(facesContext, uiComponent, metaDataEntry, convertedObject);
        this.logger.finest("initValidation of " + this.getClass().getName() + " finished");
        try {
            this.logger.finest("start processValidation of " + this.getClass().getName());
            this.processValidation(facesContext, uiComponent, metaDataEntry, convertedObject);
            this.logger.finest("processValidation of " + this.getClass().getName() + " finished");
        }
        catch (ValidatorException e) {
            this.logger.finest("start processAfterValidatorException of " + this.getClass().getName());
            ValidatorException validatorException = e instanceof RequiredValidatorException ? new RequiredValidatorException(ExtValUtils.convertFacesMessage(e.getFacesMessage()), e.getCause()) : new ValidatorException(ExtValUtils.convertFacesMessage(e.getFacesMessage()), e.getCause());
            if (this.processAfterValidatorException(facesContext, uiComponent, metaDataEntry, convertedObject, validatorException)) {
                this.logger.finest(this.getClass().getName() + ": throw original exception after processAfterValidatorException");
                ExtValUtils.tryToThrowValidatorExceptionForComponent(uiComponent, validatorException.getFacesMessage(), validatorException);
            }
            this.logger.finest(this.getClass().getName() + ": original exception after processAfterValidatorException not thrown");
        }
    }

    protected void initValidation(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject) {
    }

    protected boolean processAfterValidatorException(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject, ValidatorException validatorException) {
        return ExtValUtils.executeAfterThrowingInterceptors(uiComponent, metaDataEntry, convertedObject, validatorException, this);
    }

    protected abstract void processValidation(FacesContext var1, UIComponent var2, MetaDataEntry var3, Object var4) throws ValidatorException;
}

