/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.lib;

import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class _UrlMatcher {
    private final String excludePrefix;
    private final String excludeSuffix;

    public _UrlMatcher(FilterConfig config) {
        this.excludePrefix = config.getInitParameter("excludePrefix");
        this.excludeSuffix = config.getInitParameter("excludeSuffix");
    }

    public boolean accept(ServletRequest req) {
        if (this.excludePrefix == null && this.excludeSuffix == null) {
            return true;
        }
        if (!(req instanceof HttpServletRequest)) {
            return true;
        }
        HttpServletRequest hreq = (HttpServletRequest)req;
        String pathInfo = hreq.getPathInfo();
        String servletPath = hreq.getServletPath();
        if (this.excludePrefix != null && servletPath.startsWith(this.excludePrefix)) {
            return false;
        }
        if (this.excludeSuffix != null) {
            if (pathInfo == null && servletPath.endsWith(this.excludeSuffix)) {
                return false;
            }
            if (pathInfo != null && pathInfo.endsWith(this.excludeSuffix)) {
                return false;
            }
        }
        return true;
    }
}

