/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.shared_orchestra.util.el;

import org.apache.myfaces.shared_orchestra.util.el.GenericMap;

/**
 * You can use this class to perform tests.
 * Use this for example in JSF backing beans, like BaseFace.getUserInRole(String).
 *
 * @author Sylvain Vieujot (latest modification by $Author: skitching $)
 * @version $Revision: 355303 $ $Date: 2005-12-09 02:36:08 +0100 (Fr, 09 Dez 2005) $
 *
 */
public abstract class StringMap extends GenericMap {

    /**
     * This method should return the result of the test.
     */
    public abstract String getString(String testKey);

    public Object getValue(Object testKey){
        return getString( (String) testKey );
    }

    public Object get(Object key) {
        if( ! (key instanceof String) )
            return null;
        return getString( (String)key );
    }
}

