/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.io.UnsupportedEncodingException;

class _Hex {
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final String charsetName;

    public static byte[] decodeHex(char[] data) throws Exception {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new Exception("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = _Hex.toDigit(data[j], j) << 4;
            f |= _Hex.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static char[] encodeHex(byte[] data) {
        return _Hex.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return _Hex.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexString(byte[] data) {
        return new String(_Hex.encodeHex(data));
    }

    protected static int toDigit(char ch, int index) throws Exception {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new Exception("Illegal hexadecimal charcter " + ch + " at index " + index);
        }
        return digit;
    }

    public _Hex() {
        this.charsetName = DEFAULT_CHARSET_NAME;
    }

    public _Hex(String csName) {
        this.charsetName = csName;
    }

    public byte[] decode(byte[] array) throws Exception {
        try {
            return _Hex.decodeHex(new String(array, this.getCharsetName()).toCharArray());
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public Object decode(Object object) throws Exception {
        try {
            char[] charArray = object instanceof String ? ((String)object).toCharArray() : (char[])object;
            return _Hex.decodeHex(charArray);
        }
        catch (ClassCastException e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public byte[] encode(byte[] array) {
        return _Hex.getBytesUnchecked(_Hex.encodeHexString(array), this.getCharsetName());
    }

    private static byte[] getBytesUnchecked(String string, String charsetName) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(charsetName, e);
        }
    }

    public Object encode(Object object) throws Exception {
        try {
            byte[] byteArray = object instanceof String ? ((String)object).getBytes(this.getCharsetName()) : (byte[])object;
            return _Hex.encodeHex(byteArray);
        }
        catch (ClassCastException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public String toString() {
        return super.toString() + "[charsetName=" + this.charsetName + "]";
    }
}

