/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html;

import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UISelectManyBox;
import org.apache.myfaces.tobago.component.UISelectOneChoice;
import org.apache.myfaces.tobago.renderkit.html.JsonUtils;

public class Select2Options {
    private Boolean allowClear;
    private Boolean dropdownAutoWidth;
    private Boolean hideDropdown;
    private String language;
    private String matcher;
    private Integer maximumInputLength;
    private Integer minimumInputLength;
    private Integer maximumSelectionLength;
    private Integer minimumResultsForSearch;
    private boolean minimumResultsForSearchSet;
    private String placeholder;
    private boolean renderSelect2;
    private Boolean tags;
    private String tokenizer;
    private String[] tokenSeparators;

    public static Select2Options of(UISelectOneChoice select) {
        String placeholder;
        FacesContext facesContext;
        Select2Options options = new Select2Options();
        options.renderSelect2 = select.isSelect2();
        options.dropdownAutoWidth = true;
        if (select.isMinimumResultsForSearchSet()) {
            options.setMinimumResultsForSearch(select.getMinimumResultsForSearch());
        }
        if (select.isAllowCustomSet()) {
            options.setTags(select.isAllowCustom());
        }
        if (select.isAllowClearSet()) {
            options.setAllowClear(select.isAllowClear());
        }
        if ((facesContext = FacesContext.getCurrentInstance()) != null) {
            options.setLanguage(facesContext.getViewRoot().getLocale().getLanguage());
        }
        if (select.isMatcherSet()) {
            options.setMatcher(select.getMatcher());
        }
        if (select.isMaximumInputLengthSet()) {
            options.setMaximumInputLength(select.getMaximumInputLength());
        }
        if (select.isMinimumInputLengthSet()) {
            options.setMinimumInputLength(select.getMinimumInputLength());
        }
        if (select.isMaximumSelectionLengthSet()) {
            options.setMaximumSelectionLength(select.getMaximumSelectionLength());
        }
        if ((placeholder = select.getPlaceholder()) != null && placeholder.length() > 0) {
            options.setPlaceholder(placeholder);
        }
        return options;
    }

    public static Select2Options of(UISelectManyBox select) {
        String placeholder;
        FacesContext facesContext;
        Select2Options options = new Select2Options();
        if (select.isMinimumResultsForSearchSet()) {
            options.setMinimumResultsForSearch(select.getMinimumResultsForSearch());
        }
        if (select.isAllowCustomSet()) {
            options.setTags(select.isAllowCustom());
        }
        if (select.isAllowClearSet()) {
            options.setAllowClear(select.isAllowClear());
        }
        if (select.isHideDropdown()) {
            options.setHideDropdown(true);
        }
        if ((facesContext = FacesContext.getCurrentInstance()) != null) {
            options.setLanguage(facesContext.getViewRoot().getLocale().getLanguage());
        }
        if (select.isMatcherSet()) {
            options.setMatcher(select.getMatcher());
        }
        if (select.isMaximumInputLengthSet()) {
            options.setMaximumInputLength(select.getMaximumInputLength());
        }
        if (select.isMinimumInputLengthSet()) {
            options.setMinimumInputLength(select.getMinimumInputLength());
        }
        if (select.isMaximumSelectionLengthSet()) {
            options.setMaximumSelectionLength(select.getMaximumSelectionLength());
        }
        if (select.isTokenizerSet()) {
            options.setTokenizer(select.getTokenizer());
        }
        if (select.isTokenSeparatorsSet()) {
            options.setTokenSeparators(select.getTokenSeparators());
        }
        if ((placeholder = select.getPlaceholder()) != null && placeholder.length() > 0) {
            options.setPlaceholder(placeholder);
        }
        return options;
    }

    public boolean hasAnyOption() {
        return this.renderSelect2 || this.allowClear != null || this.matcher != null || this.maximumInputLength != null || this.minimumInputLength != null || this.maximumSelectionLength != null || this.minimumResultsForSearchSet || this.placeholder != null || this.tags != null || this.tokenizer != null || this.tokenSeparators != null;
    }

    public Boolean isTags() {
        return this.tags;
    }

    public void setTags(Boolean tags) {
        this.tags = tags;
    }

    public String getTokenizer() {
        return this.tokenizer;
    }

    public void setTokenizer(String tokenizer) {
        this.tokenizer = tokenizer;
    }

    public String[] getTokenSeparators() {
        return this.tokenSeparators;
    }

    public void setTokenSeparators(String[] tokenSeparators) {
        this.tokenSeparators = tokenSeparators;
    }

    public Boolean isAllowClear() {
        return this.allowClear;
    }

    public void setAllowClear(Boolean allowClear) {
        this.allowClear = allowClear;
    }

    public Boolean getHideDropdown() {
        return this.hideDropdown;
    }

    public void setHideDropdown(Boolean hideDropdown) {
        this.hideDropdown = hideDropdown;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String matcher) {
        this.matcher = matcher;
    }

    public Integer getMaximumInputLength() {
        return this.maximumInputLength;
    }

    public void setMaximumInputLength(Integer maximumInputLength) {
        this.maximumInputLength = maximumInputLength;
    }

    public Integer getMinimumInputLength() {
        return this.minimumInputLength;
    }

    public void setMinimumInputLength(Integer minimumInputLength) {
        this.minimumInputLength = minimumInputLength;
    }

    public Integer getMaximumSelectionLength() {
        return this.maximumSelectionLength;
    }

    public void setMaximumSelectionLength(Integer maximumSelectionLength) {
        this.maximumSelectionLength = maximumSelectionLength;
    }

    public Integer getMinimumResultsForSearch() {
        return this.minimumResultsForSearch;
    }

    public void setMinimumResultsForSearch(Integer minimumResultsForSearch) {
        this.minimumResultsForSearch = minimumResultsForSearch;
        this.minimumResultsForSearchSet = true;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public String toJson() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (this.tags != null) {
            JsonUtils.encode(builder, "tags", this.tags);
        }
        if (this.tokenizer != null) {
            JsonUtils.encode(builder, "tokenizer", this.tokenizer);
        }
        if (this.tokenSeparators != null) {
            JsonUtils.encode(builder, "tokenSeparators", this.tokenSeparators);
        }
        if (this.dropdownAutoWidth != null) {
            JsonUtils.encode(builder, "dropdownAutoWidth", this.dropdownAutoWidth);
        }
        if (this.allowClear != null) {
            JsonUtils.encode(builder, "allowClear", this.allowClear);
        }
        if (this.hideDropdown != null && this.hideDropdown.booleanValue()) {
            JsonUtils.encode(builder, "dropdownCssClass", "tobago-select2-hide-dropdown");
        }
        if (this.language != null) {
            JsonUtils.encode(builder, "language", this.language);
        }
        if (this.matcher != null) {
            JsonUtils.encode(builder, "matcher", this.matcher);
        }
        if (this.maximumInputLength != null) {
            JsonUtils.encode(builder, "maximumInputLength", this.maximumInputLength);
        }
        if (this.minimumInputLength != null) {
            JsonUtils.encode(builder, "minimumInputLength", this.minimumInputLength);
        }
        if (this.maximumSelectionLength != null) {
            JsonUtils.encode(builder, "maximumSelectionLength", this.maximumSelectionLength);
        }
        if (this.minimumResultsForSearch != null) {
            JsonUtils.encode(builder, "minimumResultsForSearch", this.minimumResultsForSearch);
        }
        if (this.placeholder != null) {
            JsonUtils.encode(builder, "placeholder", this.placeholder);
        }
        if (builder.length() > 0 && builder.charAt(builder.length() - 1) == ',') {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("}");
        return builder.toString();
    }
}

