/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib.component;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.faces.webapp.UIComponentELTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public abstract class ConverterTag
extends TagSupport {
    private static final long serialVersionUID = 2L;
    private ValueExpression binding;
    private ValueExpression converterId;

    public int doStartTag() throws JspException {
        UIComponentClassicTagBase tag = UIComponentELTag.getParentUIComponentClassicTagBase((PageContext)this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in faces tag");
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        if (component == null) {
            throw new JspException("Component Instance is null");
        }
        if (!(component instanceof ValueHolder)) {
            throw new JspException("Component " + component.getClass().getName() + " is not instanceof ValueHolder");
        }
        ValueHolder valueHolder = (ValueHolder)component;
        Converter converter = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        if (this.binding != null && !this.binding.isLiteralText()) {
            converter = (Converter)this.binding.getValue(elContext);
        }
        if (converter == null && this.converterId != null) {
            String localConverterId = (String)this.converterId.getValue(elContext);
            converter = facesContext.getApplication().createConverter(localConverterId);
        }
        if (converter != null) {
            if (!this.binding.isLiteralText()) {
                ValueExpression ve = component.getValueExpression("converter");
                if (ve != null) {
                    ve.setValue(elContext, (Object)converter);
                }
            } else {
                valueHolder.setConverter(converter);
            }
        }
        return 0;
    }

    public void release() {
        super.release();
        this.binding = null;
        this.converterId = null;
    }

    public void setConverterId(ValueExpression converterId) {
        this.converterId = converterId;
    }

    public void setBinding(ValueExpression binding) {
        this.binding = binding;
    }
}

