/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUIForm;
import org.apache.myfaces.tobago.internal.renderkit.Collapse;
import org.apache.myfaces.tobago.internal.renderkit.renderer.TobagoClientBehaviorRenderer;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Command {
    private static final Logger LOG = LoggerFactory.getLogger(Command.class);
    private String action;
    private Boolean transition;
    private String target;
    private String execute;
    private String render;
    private String focus;
    private String confirmation;
    private Integer delay;
    private Collapse collapse;
    private Boolean omit;

    public Command() {
    }

    public Command(String action, Boolean transition, String target, String execute, String render, String focus, String confirmation, Integer delay, Collapse collapse, Boolean omit) {
        this.action = action;
        this.transition = transition;
        this.target = target;
        this.setExecute(execute);
        this.setRender(render);
        this.focus = focus;
        this.confirmation = confirmation;
        this.delay = delay;
        this.collapse = collapse;
        this.omit = omit;
    }

    public Command(FacesContext facesContext, AbstractUICommand command) {
        this(null, command.isTransition(), command.getTarget(), null, null, null, ComponentUtils.getConfirmation((UIComponent)command), null, TobagoClientBehaviorRenderer.createCollapsible(facesContext, (UIComponent)command), command.isOmit());
    }

    public Command(FacesContext facesContext, UIComponent facetComponent, String focusId) {
        int delayAttribute;
        String targetAttribute;
        UIComponent component;
        if (facetComponent instanceof AbstractUIForm && facetComponent.getChildCount() == 1) {
            LOG.warn("Please don't use a form, but a command with immediate=true instead.");
            component = (UIComponent)facetComponent.getChildren().get(0);
        } else {
            component = facetComponent;
        }
        this.action = component.getClientId(facesContext);
        if (!ComponentUtils.getBooleanAttribute(component, Attributes.transition)) {
            this.transition = Boolean.FALSE;
        }
        if ((targetAttribute = ComponentUtils.getStringAttribute(component, Attributes.target)) != null) {
            this.target = targetAttribute;
        }
        if (focusId != null) {
            this.focus = focusId;
        }
        if ((delayAttribute = ComponentUtils.getIntAttribute(component, Attributes.delay)) > 0) {
            this.delay = delayAttribute;
        }
        if (ComponentUtils.getBooleanAttribute(component, Attributes.omit)) {
            this.omit = Boolean.TRUE;
        }
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Boolean getTransition() {
        return this.transition;
    }

    public void setTransition(Boolean transition) {
        this.transition = transition;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getExecute() {
        return this.execute;
    }

    public void setExecute(String execute) {
        if (StringUtils.isNotBlank(execute)) {
            this.execute = execute;
        }
    }

    public String getRender() {
        return this.render;
    }

    public void setRender(String render) {
        if (StringUtils.isNotBlank(render)) {
            this.render = render;
        }
    }

    public String getFocus() {
        return this.focus;
    }

    public void setFocus(String focus) {
        this.focus = focus;
    }

    public String getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(String confirmation) {
        this.confirmation = confirmation;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public Collapse getCollapse() {
        return this.collapse;
    }

    public void setCollapse(Collapse collapse) {
        this.collapse = collapse;
    }

    public Boolean getOmit() {
        return this.omit;
    }

    public void setOmit(Boolean omit) {
        this.omit = omit;
    }

    public void merge(Command c) {
        if (this.action == null) {
            this.action = c.action;
        }
        if (this.transition == null) {
            this.transition = c.transition;
        }
        if (this.target == null) {
            this.target = c.target;
        }
        if (this.execute != null) {
            if (c.execute != null) {
                this.execute = this.execute + " " + c.execute;
            }
        } else {
            this.execute = c.execute;
        }
        if (this.render != null) {
            if (c.render != null) {
                this.render = this.render + " " + c.render;
            }
        } else {
            this.render = c.render;
        }
        if (this.focus == null) {
            this.focus = c.focus;
        }
        if (this.confirmation == null) {
            this.confirmation = c.confirmation;
        }
        if (this.delay == null) {
            this.delay = c.delay;
        }
        if (this.collapse == null) {
            this.collapse = c.collapse;
        }
        if (this.omit == null) {
            this.omit = c.omit;
        }
    }
}

