/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsLabelLayout;

public enum LabelLayout {
    none,
    flexLeft,
    flexRight,
    top,
    segmentLeft,
    segmentRight,
    flowLeft,
    flowRight,
    skip,
    gridLeft,
    gridRight,
    gridTop,
    gridBottom;

    private static final String SEGMENT_TO_RENDER_KEY;

    public static boolean isSegment(LabelLayout labelLayout) {
        return labelLayout == segmentLeft || labelLayout == segmentRight;
    }

    public static void setSegment(FacesContext facesContext, LabelLayout labelLayout) {
        if (labelLayout != segmentLeft && labelLayout != segmentRight) {
            throw new IllegalArgumentException("not supported: " + (Object)((Object)labelLayout));
        }
        facesContext.getAttributes().put(SEGMENT_TO_RENDER_KEY, labelLayout);
    }

    public static LabelLayout getSegment(FacesContext facesContext) {
        return (LabelLayout)((Object)facesContext.getAttributes().get(SEGMENT_TO_RENDER_KEY));
    }

    public static void removeSegment(FacesContext facesContext) {
        facesContext.getAttributes().remove(SEGMENT_TO_RENDER_KEY);
    }

    public static boolean isGridLeft(UIComponent component) {
        return component instanceof SupportsLabelLayout && ((SupportsLabelLayout)component).getLabelLayout() == gridLeft;
    }

    public static boolean isGridRight(UIComponent component) {
        return component instanceof SupportsLabelLayout && ((SupportsLabelLayout)component).getLabelLayout() == gridRight;
    }

    public static boolean isGridTop(UIComponent component) {
        return component instanceof SupportsLabelLayout && ((SupportsLabelLayout)component).getLabelLayout() == gridTop;
    }

    public static boolean isGridBottom(UIComponent component) {
        return component instanceof SupportsLabelLayout && ((SupportsLabelLayout)component).getLabelLayout() == gridBottom;
    }

    static {
        SEGMENT_TO_RENDER_KEY = LabelLayout.class.getName();
    }
}

