/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.component.SupportsLabelLayout;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecodingInputRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public abstract class LabelLayoutRendererBase
extends DecodingInputRendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        this.encodeBeginSurroundingLabel(facesContext, component);
        this.encodeBeginMessageField(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        this.encodeEndMessageField(facesContext, component);
        if (component.getRendersChildren()) {
            List<AbstractUIStyle> children = ComponentUtils.findDescendantList(component, AbstractUIStyle.class);
            for (AbstractUIStyle child : children) {
                child.encodeAll(facesContext);
            }
        }
        this.encodeEndSurroundingLabel(facesContext, component);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                if (!child.isRendered() || child instanceof AbstractUIStyle) continue;
                child.encodeAll(context);
            }
        }
    }

    protected abstract void encodeBeginMessageField(FacesContext var1, UIComponent var2) throws IOException;

    protected abstract void encodeEndMessageField(FacesContext var1, UIComponent var2) throws IOException;

    protected void encodeBeginSurroundingLabel(FacesContext facesContext, UIComponent component) throws IOException {
        boolean flex;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        Markup markup = (Markup)ComponentUtils.getAttribute(component, Attributes.markup);
        LabelLayout labelLayout = ((SupportsLabelLayout)component).getLabelLayout();
        switch (labelLayout) {
            case skip: {
                return;
            }
            case flexLeft: 
            case flexRight: {
                flex = true;
                break;
            }
            case segmentLeft: 
            case segmentRight: {
                if (LabelLayout.getSegment(facesContext) == labelLayout) {
                    clientId = clientId + "::label";
                }
                flex = false;
                break;
            }
            default: {
                flex = false;
            }
        }
        writer.startElement(HtmlElements.DIV);
        if (labelLayout == LabelLayout.gridLeft || labelLayout == LabelLayout.gridRight || labelLayout == LabelLayout.gridTop || labelLayout == LabelLayout.gridBottom) {
            writer.writeIdAttribute(clientId + "::" + "label");
        } else {
            writer.writeIdAttribute(clientId);
        }
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        writer.writeClassAttribute(flex ? TobagoClass.FLEX_LAYOUT : null, flex ? BootstrapClass.D_FLEX : null, TobagoClass.LABEL__CONTAINER, BootstrapClass.FORM_GROUP, ComponentUtils.getBooleanAttribute(component, Attributes.required) ? TobagoClass.REQUIRED : null, markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        switch (labelLayout) {
            case none: {
                break;
            }
            case flexRight: 
            case flowRight: {
                break;
            }
            case segmentLeft: 
            case segmentRight: {
                if (LabelLayout.getSegment(facesContext) != labelLayout) break;
                this.encodeLabel(facesContext, component, writer, labelLayout);
                break;
            }
            default: {
                this.encodeLabel(facesContext, component, writer, labelLayout);
            }
        }
        switch (labelLayout) {
            case gridLeft: 
            case gridRight: 
            case gridTop: 
            case gridBottom: {
                writer.endElement(HtmlElements.DIV);
                writer.startElement(HtmlElements.DIV);
                writer.writeIdAttribute(clientId);
                writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
                writer.writeClassAttribute(TobagoClass.LABEL__CONTAINER, BootstrapClass.FORM_GROUP, ComponentUtils.getBooleanAttribute(component, Attributes.required) ? TobagoClass.REQUIRED : null, markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
                break;
            }
        }
    }

    protected void encodeEndSurroundingLabel(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        LabelLayout labelLayout = ((SupportsLabelLayout)component).getLabelLayout();
        switch (labelLayout) {
            case skip: {
                return;
            }
            case none: {
                break;
            }
            case flexRight: 
            case flowRight: {
                this.encodeLabel(facesContext, component, writer, labelLayout);
                break;
            }
        }
        writer.endElement(HtmlElements.DIV);
    }

    protected void encodeLabel(FacesContext facesContext, UIComponent component, TobagoResponseWriter writer, LabelLayout labelLayout) throws IOException {
        String label = ComponentUtils.getStringAttribute(component, Attributes.label);
        if (StringUtils.isNotBlank(label)) {
            writer.startElement(HtmlElements.LABEL);
            writer.writeAttribute(HtmlAttributes.FOR, this.getFieldId(facesContext, component), false);
            writer.writeClassAttribute(TobagoClass.LABEL, BootstrapClass.COL_FORM_LABEL);
            if (component instanceof SupportsAccessKey) {
                LabelWithAccessKey labelWithAccessKey = new LabelWithAccessKey((SupportsAccessKey)component);
                HtmlRendererUtils.writeLabelWithAccessKey(writer, labelWithAccessKey);
            } else {
                writer.writeText(label);
            }
            writer.endElement(HtmlElements.LABEL);
        }
    }

    protected abstract String getFieldId(FacesContext var1, UIComponent var2);
}

