/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.css;

import java.lang.invoke.MethodHandles;
import java.util.regex.Pattern;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Icons implements CssItem
{
    ARROW_DOWN,
    CHEVRON_DOUBLE_LEFT,
    CHEVRON_DOUBLE_RIGHT,
    CHEVRON_LEFT,
    CHEVRON_RIGHT,
    CARET_LEFT,
    CALENDAR3,
    CLOCK,
    THREE_DOTS,
    EXCLAMATION,
    EXCLAMATION_LG,
    FOLDER2_OPEN,
    CARET_RIGHT,
    DASH_SQUARE,
    PLUS_SQUARE,
    QUESTION,
    QUESTION_LG,
    SQUARE,
    SKIP_START,
    SKIP_END;

    private static final Logger LOG;
    private static final Pattern PATTERN_BI;
    private static final Pattern PATTERN_FA;
    private static final Pattern PATTERN_FA5;
    private static final Pattern PATTERN_FA6;
    private final String clazz = "bi-" + this.name().toLowerCase().replaceAll("_", "-");

    @Override
    public String getName() {
        return this.clazz;
    }

    public static boolean matches(String value) {
        return Icons.custom(value).getName() != null;
    }

    public static CssItem custom(final String name) {
        return new CssItem(){

            @Override
            public String getName() {
                if (name == null) {
                    return null;
                }
                if (PATTERN_BI.matcher(name).matches()) {
                    return name;
                }
                if (PATTERN_FA6.matcher(name).matches()) {
                    return name;
                }
                if (PATTERN_FA5.matcher(name).matches()) {
                    return name;
                }
                if (PATTERN_FA.matcher(name).matches()) {
                    return "fa " + name;
                }
                LOG.warn("Unknown icon format for name: '" + name + "'");
                return null;
            }
        };
    }

    static {
        LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        PATTERN_BI = Pattern.compile("^bi-[\\w\\d-]+$");
        PATTERN_FA = Pattern.compile("^fa-[\\w\\d-]+$");
        PATTERN_FA5 = Pattern.compile("^(fas|far|fal|fad|fab)\\sfa-[\\w\\d-]+$");
        PATTERN_FA6 = Pattern.compile("^(fa-sharp\\s)?fa-(solid|regular|light|duotone|thin)\\sfa-[\\w\\d-]+$");
    }
}

