/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIBar;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BarRenderer<T extends AbstractUIBar>
extends RendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        this.insideBegin(facesContext, HtmlElements.TOBAGO_BAR);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        String navbarId = clientId + "::navbar";
        Markup markup = component.getMarkup();
        writer.startElement(HtmlElements.TOBAGO_BAR);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(BootstrapClass.NAVBAR, this.getNavbarExpand(markup), this.getNavbarColorScheme(markup), component.getCustomClass());
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.NAVIGATION.toString(), false);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.CONTAINER_FLUID);
        this.encodeOpener(facesContext, (AbstractUIBar)component, writer, navbarId);
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(navbarId);
        writer.writeClassAttribute(BootstrapClass.COLLAPSE, BootstrapClass.NAVBAR_COLLAPSE, BootstrapClass.ALIGN_ITEMS_CENTER);
    }

    private BootstrapClass getNavbarExpand(Markup markup) {
        if (markup != null) {
            if (markup.contains(Markup.EXTRA_LARGE)) {
                return BootstrapClass.NAVBAR_EXPAND_XL;
            }
            if (markup.contains(Markup.LARGE)) {
                return BootstrapClass.NAVBAR_EXPAND_LG;
            }
            if (markup.contains(Markup.MEDIUM)) {
                return BootstrapClass.NAVBAR_EXPAND_MD;
            }
            if (markup.contains(Markup.SMALL)) {
                return BootstrapClass.NAVBAR_EXPAND_SM;
            }
        }
        return BootstrapClass.NAVBAR_EXPAND;
    }

    private BootstrapClass getNavbarColorScheme(Markup markup) {
        if (markup != null) {
            if (markup.contains(Markup.DARK)) {
                return BootstrapClass.NAVBAR_DARK;
            }
            if (markup.contains(Markup.LIGHT)) {
                return BootstrapClass.NAVBAR_LIGHT;
            }
        }
        return null;
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        UIComponent after = ComponentUtils.getFacet(component, Facets.after);
        if (after != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.MY_LG_0, BootstrapClass.MS_AUTO);
            this.insideBegin(facesContext, Facets.after);
            after.encodeAll(facesContext);
            this.insideEnd(facesContext, Facets.after);
            writer.endElement(HtmlElements.DIV);
        }
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.TOBAGO_BAR);
        this.insideEnd(facesContext, HtmlElements.TOBAGO_BAR);
    }

    private void encodeOpener(FacesContext facesContext, AbstractUIBar bar, TobagoResponseWriter writer, String navbarId) throws IOException {
        boolean togglerLeft = bar.getMarkup() != null && bar.getMarkup().contains(Markup.TOGGLER_LEFT);
        UIComponent brand = ComponentUtils.getFacet((UIComponent)bar, Facets.brand);
        if (brand != null && !togglerLeft) {
            writer.startElement(HtmlElements.SPAN);
            writer.writeClassAttribute(BootstrapClass.NAVBAR_BRAND);
            brand.encodeAll(facesContext);
            writer.endElement(HtmlElements.SPAN);
        }
        writer.startElement(HtmlElements.BUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(BootstrapClass.NAVBAR_TOGGLER);
        writer.writeAttribute(DataAttributes.TOGGLE, "collapse", false);
        writer.writeAttribute(DataAttributes.TARGET, "#" + navbarId, true);
        writer.writeAttribute(Arias.EXPANDED, Boolean.FALSE.toString(), false);
        writer.writeAttribute(Arias.CONTROLS, navbarId, false);
        writer.writeAttribute(Arias.LABEL, "Toggle navigation", false);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(BootstrapClass.NAVBAR_TOGGLER_ICON);
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.BUTTON);
        if (brand != null && togglerLeft) {
            writer.startElement(HtmlElements.SPAN);
            writer.writeClassAttribute(BootstrapClass.NAVBAR_BRAND);
            brand.encodeAll(facesContext);
            writer.endElement(HtmlElements.SPAN);
        }
    }
}

