/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorBase;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.ClientBehaviorRenderer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.myfaces.tobago.component.ClientBehaviors;
import org.apache.myfaces.tobago.internal.behavior.EventBehavior;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUIEvent;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNodeBase;
import org.apache.myfaces.tobago.internal.renderkit.Command;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.internal.renderkit.renderer.TobagoClientBehaviorRenderer;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private RenderUtils() {
    }

    @Deprecated
    public static boolean contains(Object[] list, Object value) {
        return ArrayUtils.contains(list, value);
    }

    @Deprecated
    public static void encodeChildren(FacesContext facesContext, UIComponent panel) throws IOException {
        for (UIComponent child : panel.getChildren()) {
            child.encodeAll(facesContext);
        }
    }

    @Deprecated
    public static void encode(FacesContext facesContext, UIComponent component) throws IOException {
        component.encodeAll(facesContext);
    }

    @Deprecated
    public static void encode(FacesContext facesContext, UIComponent component, List<? extends Class<? extends UIComponent>> only) throws IOException {
        if (only != null && !RenderUtils.matchFilter(component, only)) {
            return;
        }
        if (component.isRendered()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("rendering " + component.getRendererType() + " " + component);
            }
            component.encodeBegin(facesContext);
            if (component.getRendersChildren()) {
                component.encodeChildren(facesContext);
            } else {
                for (UIComponent child : component.getChildren()) {
                    RenderUtils.encode(facesContext, child, only);
                }
            }
            component.encodeEnd(facesContext);
        }
    }

    @Deprecated
    private static boolean matchFilter(UIComponent component, List<? extends Class<? extends UIComponent>> only) {
        for (Class<? extends UIComponent> clazz : only) {
            if (!clazz.isAssignableFrom(component.getClass())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static String currentValue(UIComponent component) {
        return new RendererBase<UIComponent>(){

            public String fake(UIComponent component) {
                return this.getCurrentValue(FacesContext.getCurrentInstance(), component);
            }
        }.fake(component);
    }

    public static void decodedStateOfTreeData(FacesContext facesContext, AbstractUIData data) {
        if (!data.isTreeModel()) {
            return;
        }
        List<Integer> selectedIndices = RenderUtils.decodeIndices(facesContext, data, "selected");
        List<Integer> expandedIndices = RenderUtils.decodeIndices(facesContext, data, "expanded");
        int last = data.isRowsUnlimited() ? Integer.MAX_VALUE : data.getFirst() + data.getRows();
        for (int rowIndex = data.getFirst(); rowIndex < last; ++rowIndex) {
            data.setRowIndex(rowIndex);
            if (!data.isRowAvailable()) break;
            boolean skip = false;
            for (UIComponent uiComponent : data.getChildren()) {
                if (!(uiComponent instanceof AbstractUITreeNodeBase) || uiComponent.isRendered()) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            TreePath path = data.getPath();
            if (selectedIndices != null) {
                SelectedState selectedState = data.getSelectedState();
                boolean oldSelected = selectedState.isSelected(path);
                boolean newSelected = selectedIndices.contains(rowIndex);
                if (newSelected != oldSelected) {
                    if (newSelected) {
                        selectedState.select(path);
                    } else {
                        selectedState.unselect(path);
                    }
                }
            }
            if (expandedIndices == null) continue;
            ExpandedState expandedState = data.getExpandedState();
            boolean oldExpanded = expandedState.isExpanded(path);
            boolean newExpanded = expandedIndices.contains(rowIndex);
            if (newExpanded == oldExpanded) continue;
            if (newExpanded) {
                expandedState.expand(path);
                continue;
            }
            expandedState.collapse(path);
        }
        data.setRowIndex(-1);
    }

    private static List<Integer> decodeIndices(FacesContext facesContext, AbstractUIData data, String suffix) {
        String string = null;
        String key = data.getClientId(facesContext) + "::" + suffix;
        try {
            string = (String)facesContext.getExternalContext().getRequestParameterMap().get(key);
            return JsonUtils.decodeIntegerArray(string);
        }
        catch (Exception e) {
            LOG.warn("Can't parse " + suffix + ": '" + string + "' from parameter '" + key + "'", (Throwable)e);
            return null;
        }
    }

    public static String generateUrl(FacesContext facesContext, AbstractUICommandBase component) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String outcome = component.getOutcome();
        String link = component.getLink();
        String url = null;
        if (outcome != null) {
            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
            url = viewHandler.getBookmarkableURL(facesContext, outcome, Collections.emptyMap(), true);
        } else if (link != null) {
            url = StringUtils.isUrl(link) ? link : externalContext.encodeResourceURL(link);
        }
        if (link != null || outcome != null) {
            String characterEncoding = facesContext.getResponseWriter().getCharacterEncoding();
            StringBuilder builder = new StringBuilder(url);
            boolean firstParameter = !url.contains("?");
            for (UIComponent child : component.getChildren()) {
                if (!(child instanceof UIParameter)) continue;
                UIParameter parameter = (UIParameter)child;
                if (firstParameter) {
                    builder.append("?");
                    firstParameter = false;
                } else {
                    builder.append("&");
                }
                RenderUtils.appendUrlEncoded(builder, parameter.getName(), characterEncoding);
                builder.append("=");
                RenderUtils.appendUrlEncoded(builder, parameter.getValue(), characterEncoding);
            }
            String fragment = component.getFragment();
            if (StringUtils.isNotBlank(fragment)) {
                builder.append("#");
                RenderUtils.appendUrlEncoded(builder, fragment.trim(), characterEncoding);
            }
            url = builder.toString();
        }
        return url;
    }

    private static void appendUrlEncoded(StringBuilder builder, Object value, String characterEncoding) {
        if (value != null) {
            try {
                String encode = URLEncoder.encode(value.toString(), characterEncoding);
                builder.append(encode.replace("+", "%20"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("string='" + value + "'", (Throwable)e);
            }
        }
    }

    @Deprecated
    public static CommandMap getBehaviorCommands(FacesContext facesContext, ClientBehaviorHolder clientBehaviorHolder) {
        CommandMap commandMap = null;
        for (Map.Entry entry : clientBehaviorHolder.getClientBehaviors().entrySet()) {
            String eventName = (String)entry.getKey();
            ClientBehaviorContext clientBehaviorContext = RenderUtils.getClientBehaviorContext(facesContext, clientBehaviorHolder, eventName);
            for (ClientBehavior clientBehavior : (List)entry.getValue()) {
                EventBehavior eventBehavior;
                AbstractUIEvent abstractUIEvent;
                if (clientBehavior instanceof EventBehavior && (abstractUIEvent = RenderUtils.getAbstractUIEvent((UIComponent)clientBehaviorHolder, eventBehavior = (EventBehavior)clientBehavior)) != null && abstractUIEvent.isRendered() && !abstractUIEvent.isDisabled()) {
                    for (List children : abstractUIEvent.getClientBehaviors().values()) {
                        for (ClientBehavior child : children) {
                            CommandMap childMap = RenderUtils.getCommandMap(facesContext, clientBehaviorContext, child);
                            commandMap = CommandMap.merge(commandMap, childMap);
                        }
                    }
                }
                CommandMap map = RenderUtils.getCommandMap(facesContext, clientBehaviorContext, clientBehavior);
                commandMap = CommandMap.merge(commandMap, map);
            }
        }
        if ((commandMap == null || commandMap.isEmpty()) && clientBehaviorHolder instanceof AbstractUICommand) {
            if (commandMap == null) {
                commandMap = new CommandMap();
            }
            AbstractUICommand holder = (AbstractUICommand)clientBehaviorHolder;
            commandMap.addCommand(ClientBehaviors.click, new Command(holder.getClientId(facesContext), holder.getFieldId(facesContext), holder.isTransition(), holder.getTarget(), null, null, ComponentUtils.getConfirmation((UIComponent)holder), null, TobagoClientBehaviorRenderer.createCollapsible(facesContext, (UIComponent)holder), holder.isOmit()));
        }
        return commandMap;
    }

    @Deprecated
    private static ClientBehaviorContext getClientBehaviorContext(FacesContext facesContext, ClientBehaviorHolder clientBehaviorHolder, String eventName) {
        UIComponent component = (UIComponent)clientBehaviorHolder;
        return ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)component, (String)eventName, (String)component.getClientId(facesContext), null);
    }

    public static AbstractUIEvent getAbstractUIEvent(UIComponent parent, EventBehavior eventBehavior) {
        return parent.getChildren().stream().filter(child -> child instanceof AbstractUIEvent).filter(child -> Objects.equals(child.getId(), eventBehavior.getFor())).findFirst().orElse(null);
    }

    @Deprecated
    private static CommandMap getCommandMap(FacesContext facesContext, ClientBehaviorContext clientBehaviorContext, ClientBehavior clientBehavior) {
        if (clientBehavior instanceof ClientBehaviorBase) {
            ClientBehaviorRenderer renderer;
            String dummy;
            String type = ((ClientBehaviorBase)clientBehavior).getRendererType();
            if (type.equals("jakarta.faces.behavior.Ajax")) {
                type = "org.apache.myfaces.tobago.behavior.Ajax";
            }
            if ((dummy = (renderer = facesContext.getRenderKit().getClientBehaviorRenderer(type)).getScript(clientBehaviorContext, clientBehavior)) != null) {
                return CommandMap.restoreCommandMap(facesContext);
            }
        } else {
            LOG.warn("Ignoring: '{}'", (Object)clientBehavior);
        }
        return null;
    }

    public static void decodeClientBehaviors(FacesContext facesContext, UIComponent component) {
        List clientBehaviorList;
        Map paramMap;
        String behaviorEventName;
        ClientBehaviorHolder clientBehaviorHolder;
        Map clientBehaviors;
        if (component instanceof ClientBehaviorHolder && (clientBehaviors = (clientBehaviorHolder = (ClientBehaviorHolder)component).getClientBehaviors()) != null && !clientBehaviors.isEmpty() && (behaviorEventName = (String)(paramMap = facesContext.getExternalContext().getRequestParameterMap()).get("jakarta.faces.behavior.event")) != null && (clientBehaviorList = (List)clientBehaviors.get(behaviorEventName)) != null && !clientBehaviorList.isEmpty()) {
            String clientId = (String)paramMap.get("jakarta.faces.source");
            if (component.getClientId(facesContext).equals(clientId)) {
                for (ClientBehavior clientBehavior : clientBehaviorList) {
                    clientBehavior.decode(facesContext, component);
                }
            }
        }
    }

    public static List<UIComponent> getFacetChildren(UIComponent facet) {
        if (facet instanceof UIPanel) {
            return facet.getChildren();
        }
        return Collections.singletonList(facet);
    }
}

