/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.myfaces.portlet.faces.testsuite.tests.chapter_4.section_4_1;

import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;

import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

import org.apache.myfaces.portlet.faces.testsuite.annotation.BridgeTest;
import org.apache.myfaces.portlet.faces.testsuite.beans.TestRunnerBean;
import org.apache.myfaces.portlet.faces.testsuite.common.Constants;

public class Tests
  extends Object
{
  @BridgeTest(test = "portletInitializationParametersTest")
  public String portletInitializationParametersTest(TestRunnerBean testRunner)
  {
    // Section 4.1
    // Tests whether the GenericFacesPortlet portlet initialization 
    // parameters have been correctly set as Bridge attributes.
    String PARAM_NAMESPACE = "javax.portlet.faces.chapter4_1Tests-portletInitializationParametersTest-portlet.";
    Map<String, Object> expectedInitParams = new HashMap<String, Object>();
    Map<String, String> viewIds = new HashMap<String, String>();
    viewIds.put("view", "/tests/MultiRequestTest.jsp");
    viewIds.put("edit", "/tests/MultiRequestTest.jsp");
    viewIds.put("help", "/tests/MultiRequestTest.jsp");
    expectedInitParams.put("defaultViewIdMap", viewIds);
    List excluded = new ArrayList();
    excluded.add("test1");
    excluded.add("test2");
    expectedInitParams.put("excludedRequestAttributes", excluded);
    expectedInitParams.put("preserveActionParams", Boolean.TRUE);
    expectedInitParams.put("defaultContentType", "text/xml");
    expectedInitParams.put("defaultCharacterSetEncoding", "UTF-8");
    

    ExternalContext extCtx = FacesContext.getCurrentInstance().getExternalContext();
    // Map requestAttributes = extCtx.getRequestMap();
    // System.out.println("************  +++++++++ ");
    //for (String name: requestAttributes)
    //{
    //  System.out.println("************ " + name  + " +++++++++ ");
    //}
    for (String name: extCtx.getApplicationMap().keySet())
    {
      if (name.indexOf("chapter4_1") != -1)
      {
        System.out.println("**** " + name  + ": " + extCtx.getApplicationMap().get(name));
      }
    }
    StringBuilder notFoundMsg = new StringBuilder();

    boolean pass = checkAttrs(extCtx.getApplicationMap(), PARAM_NAMESPACE, expectedInitParams, notFoundMsg);

    if (notFoundMsg.length() != 0)
    {
      notFoundMsg.append(".  ");
    }

    if (BridgeUtil.getPortletRequestPhase() ==
        Bridge.PortletPhase.ACTION_PHASE)
    {  
 System.out.println("1a");
      if (pass)
      {
 System.out.println("1b");
 System.out.println("1c");
      }
      else
      {
        // Missing init params
        extCtx.getSessionMap().put("test.action.failed", "  Missing or incorrect init-params during action request: " + notFoundMsg); 
      }
 System.out.println("1d");
      return "portletInitializationParametersTest"; // action Navigation result
    }
    else
    {
      boolean actionPass = extCtx.getSessionMap().get("test.action.failed") == null;
      boolean completePass = pass && actionPass;
      StringBuilder msg = new StringBuilder();

      if (pass)
      {
        msg.append("Portlet initialisation parameters visible as portlet context attributes during render request.  ");
      }
      else
      {
        msg.append("Missing or incorrect init-params during render request: " + notFoundMsg);
      }

      if (actionPass)
      {
        msg.append("  Portlet initialisation parameters visible as portlet context attributes during action request.  ");
      }
      else
      {
        msg.append((String)extCtx.getSessionMap().get("test.action.failed"));
      }

      testRunner.setTestResult(completePass, msg.toString());
      if (completePass)
      {
        return Constants.TEST_SUCCESS;
      }
      else
      {
        return Constants.TEST_FAILED;
      }
    }
  }

  public boolean checkAttrs(Map attributes, String namespace, Map<String, Object> expectedInitParams, StringBuilder notFoundMsg)
  {
System.out.println("* 1");    
    if (attributes == null)
    {
      return false;
    }
    boolean pass = true;

System.out.println("* 2");
    for (String key: expectedInitParams.keySet())
    {
      // Run through the expected init param attributes.  They will either be
      // key=string, value=object, or key=defaultViewIdMap, value=map of 
      //modes (where key = string and value=string)
      
      if ("defaultViewIdMap".equals(key))
      {
        System.out.println("1");
        Map<String,String> defaultViewIdMap = (Map<String,String>)expectedInitParams.get("defaultViewIdMap");
        System.out.println("2");
        Map<String,String> attributeViewIdMap = (Map<String,String>)attributes.get(namespace + "defaultViewIdMap");
        System.out.println("3");
        if (attributeViewIdMap == null)
        {
        System.out.println("4");
          buildMsg(notFoundMsg, "init-param name = " + key);
          pass = false;
          break;
        }

        for (String mode: defaultViewIdMap.keySet())
        {
        System.out.println("5");
          if (!(defaultViewIdMap.get(mode).equals(attributeViewIdMap.get(mode))))
          {
        System.out.println("6");
            pass = false;
          }
        }
      }
      else
      {
        Object param = expectedInitParams.get(key);
        System.out.println("6 param=" + param + " key= " + key );
        System.out.println("6a namespace + key  = " + namespace + key + " value= " + key );
        try{
        System.out.println("6b value= " + attributes.get(namespace + key) );

        if (!(param.equals(attributes.get(namespace + key))))
        {
          System.out.println("7");
          buildMsg(notFoundMsg, "init-param name = " + key + ", value = " + expectedInitParams.get(key));
          pass = false;
        }
        }
        catch (Exception e)
        {
          System.out.println("7a: " + e.toString());
        }
      }
    }
    System.out.println("8");
    return pass;
  }

  private void buildMsg(StringBuilder completeMsg, String msg)
  {
    if (completeMsg.length() != 0)
    {
      completeMsg.append(", ");
    }
    
    completeMsg.append(msg);
  }
}
