/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.util;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.util.StreamingAddResource;
import org.apache.myfaces.component.html.util.StreamingThreadManager;
import org.apache.myfaces.renderkit.html.util.ResourceLoader;

public class StreamingResourceLoader
implements ResourceLoader {
    private static final Log log = LogFactory.getLog((Class)StreamingResourceLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(ServletContext context, HttpServletRequest request, HttpServletResponse response, String resourceUri) throws IOException {
        int pos = resourceUri.indexOf("/");
        Long requestId = new Long(Long.parseLong(resourceUri.substring(0, pos), 10));
        StreamingThreadManager manager = (StreamingThreadManager)context.getAttribute("org.apache.myfaces.component.html.util.StreamingThreadManager");
        StreamingThreadManager.HeaderInfoEntry headerInfoEntry = manager.getHeaderInfo(requestId);
        if (headerInfoEntry == null) {
            log.warn((Object)("No streamable resources found for request: " + requestId + " resourceUri: " + resourceUri));
            return;
        }
        response.setHeader("pragma", "no-cache");
        response.setHeader("Cache-control", "no-cache, must-revalidate");
        try {
            PrintWriter pw = response.getWriter();
            try {
                StreamingAddResource.StreamablePositionedInfo positionedInfo;
                while ((positionedInfo = headerInfoEntry.fetchInfo()) != null) {
                    positionedInfo.writePositionedInfo(response, pw);
                    pw.flush();
                }
                pw.close();
            }
            catch (InterruptedException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        finally {
            manager.removeHeaderInfo(requestId);
        }
    }
}

