/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.DefaultAddResource;
import org.apache.myfaces.renderkit.html.util.NonBufferingAddResource;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;
import org.apache.myfaces.shared_tomahawk.webapp.webxml.FilterMapping;
import org.apache.myfaces.shared_tomahawk.webapp.webxml.WebXml;
import org.apache.myfaces.tomahawk.util.ExternalContextUtils;

public class AddResourceFactory {
    protected static final Log log = LogFactory.getLog(AddResourceFactory.class);
    private static final String CACHE_MAP_KEY = "org.apache.myfaces.AddResourceFactory.CACHE_MAP_KEY";
    private static final String ENV_CHECKED_KEY = "org.apache.myfaces.AddResourceFactory.ENV_CHECKED_KEY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AddResource getInstance(Object context, Map cacheMap, String contextPath, String addResourceClassName) {
        AddResource instance = null;
        if (cacheMap != null) {
            instance = (AddResource)cacheMap.get(CACHE_MAP_KEY);
        }
        if (instance == null) {
            if (addResourceClassName == null) {
                if (context instanceof PortletContext) {
                    instance = new NonBufferingAddResource();
                    instance.setContextPath(contextPath);
                } else {
                    instance = new DefaultAddResource();
                    instance.setContextPath(contextPath);
                }
            } else {
                try {
                    Class addResourceClass = ClassUtils.classForName(addResourceClassName);
                    if (AddResource.class.isAssignableFrom(addResourceClass)) {
                        AddResource tmpInstance = (AddResource)addResourceClass.newInstance();
                        tmpInstance.setContextPath(contextPath);
                        instance = tmpInstance;
                    } else {
                        log.error((Object)("Invalid AddResource class (" + addResourceClass.getName() + "). Must implement the AddResource interface."));
                    }
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"AddResource class not found. Using default class instead", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)e);
                }
                catch (InstantiationException e) {
                    log.error((Object)"Invalid AddResource class. Must be non-abstract", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)"Could not access AddResource class", (Throwable)e);
                }
                finally {
                    if (instance == null) {
                        instance = new DefaultAddResource();
                        instance.setContextPath(contextPath);
                    }
                }
            }
            if (cacheMap != null) {
                cacheMap.put(CACHE_MAP_KEY, instance);
            }
        }
        return instance;
    }

    public static AddResource getInstance(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        AddResource addResource = AddResourceFactory.getInstance(externalContext.getContext(), externalContext.getRequestMap(), externalContext.getRequestContextPath(), MyfacesConfig.getCurrentInstance(externalContext).getAddResourceClass());
        AddResourceFactory.checkEnvironment(context, addResource);
        return addResource;
    }

    public static AddResource getInstance(HttpServletRequest request) {
        ServletContext servletContext = request.getSession().getServletContext();
        RequestMapWrapper requestMap = new RequestMapWrapper(request);
        AddResource addResource = AddResourceFactory.getInstance(servletContext, requestMap, request.getContextPath(), MyfacesConfig.getAddResourceClassFromServletContext(servletContext));
        return addResource;
    }

    public static AddResource getInstance(HttpServletRequest request, ServletContext servletContext) {
        RequestMapWrapper requestMap = new RequestMapWrapper(request);
        AddResource addResource = AddResourceFactory.getInstance(servletContext, requestMap, request.getContextPath(), MyfacesConfig.getAddResourceClassFromServletContext(servletContext));
        return addResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkEnvironment(FacesContext context, AddResource addResource) {
        ExternalContext extctx = context.getExternalContext();
        if (ExternalContextUtils.getRequestType(extctx).isPortlet()) {
            return;
        }
        if (extctx.getApplicationMap().containsKey(ENV_CHECKED_KEY)) {
            return;
        }
        if (!MyfacesConfig.getCurrentInstance(extctx).isCheckExtensionsFilter()) {
            extctx.getApplicationMap().put(ENV_CHECKED_KEY, Boolean.TRUE);
            return;
        }
        Map map = extctx.getApplicationMap();
        synchronized (map) {
            if (addResource.requiresBuffer() && !extctx.getRequestMap().containsKey("org.apache.myfaces.component.html.util.ExtensionFilter.doFilterCalled")) {
                AddResourceFactory.throwExtensionsFilterMissing("JSF mapping missing. JSF pages not covered.");
            }
            boolean foundMapping = false;
            List facesServletMappings = WebXml.getWebXml(extctx).getFacesExtensionsFilterMappings();
            for (FilterMapping filterMapping : facesServletMappings) {
                if (!AddResourceFactory.checkFilterPattern(extctx, filterMapping)) continue;
                foundMapping = true;
                break;
            }
            if (!foundMapping) {
                AddResourceFactory.throwExtensionsFilterMissing("Resource mapping missing. Resources cant be delivered.");
            }
            extctx.getApplicationMap().put(ENV_CHECKED_KEY, Boolean.TRUE);
        }
    }

    protected static boolean checkFilterPattern(ExternalContext extCtxt, FilterMapping filterMapping) {
        return filterMapping.getUrlPattern() != null && ("/faces/*".equals(filterMapping.getUrlPattern()) || (MyfacesConfig.getCurrentInstance(extCtxt).getResourceVirtualPath() + "/*").equals(filterMapping.getUrlPattern()));
    }

    private static void throwExtensionsFilterMissing(String detailReason) {
        throw new IllegalStateException("ExtensionsFilter not correctly configured. " + detailReason + " Please see: http://myfaces.apache.org/tomahawk/extensionsFilter.html");
    }

    public static class RequestMapWrapper
    implements Map {
        private final HttpServletRequest request;

        public RequestMapWrapper(HttpServletRequest request) {
            this.request = request;
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            if (key == null) {
                throw new UnsupportedOperationException("'null' key not supported");
            }
            return this.request.getAttribute(key.toString()) != null;
        }

        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object key) {
            if (key == null) {
                throw new UnsupportedOperationException("'null' key not supported");
            }
            return this.request.getAttribute(key.toString());
        }

        public Object put(Object key, Object value) {
            if (key == null) {
                throw new UnsupportedOperationException("'null' key not supported");
            }
            Object old = this.request.getAttribute(key.toString());
            this.request.setAttribute(key.toString(), value);
            return old;
        }

        public Object remove(Object key) {
            if (key == null) {
                throw new UnsupportedOperationException("'null' key not supported");
            }
            Object old = this.request.getAttribute(key.toString());
            this.request.removeAttribute(key.toString());
            return old;
        }

        public void putAll(Map arg) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

