/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.convert.ReverseDiscoveryGenericConverter;
import org.apache.myfaces.trinidadinternal.convert.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionConverter
extends ReverseDiscoveryGenericConverter {
    private final ConcurrentHashMap<Class<?>, Map<Class<?>, Constructor>> _cache = new ConcurrentHashMap();
    private static final Map<Class<?>, Constructor> _EMPTY_CONSTRUCTOR_MAP = Collections.emptyMap();
    private static final List<Class<?>> _EMPTY_SOURCE_LIST = Collections.emptyList();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ReflectionConverter.class);

    @Override
    public Object convert(Object source, Class<?> targetType) {
        Class<?> sourceClass;
        Map<Class<?>, Constructor> constructors = this._getConstructorMapForTarget(targetType);
        Constructor c = constructors.get(sourceClass = source.getClass());
        if (c == null) {
            for (Map.Entry<Class<?>, Constructor> entry : constructors.entrySet()) {
                if (!entry.getKey().isAssignableFrom(sourceClass)) continue;
                c = entry.getValue();
                break;
            }
        }
        ReflectiveOperationException cause = null;
        if (c != null) {
            try {
                return c.newInstance(source);
            }
            catch (InvocationTargetException e) {
                throw new TypeConversionException(source, targetType, e.getTargetException());
            }
            catch (InstantiationException e) {
                _LOG.severe((Throwable)e);
                cause = e;
            }
            catch (IllegalAccessException e) {
                _LOG.severe((Throwable)e);
                cause = e;
            }
        }
        throw new IllegalArgumentException(_LOG.getMessage("UNSUPPORTED_CONVERSION", new Object[]{source.getClass(), targetType}), cause);
    }

    @Override
    public List<Class<?>> getSourceTypes(Class<?> targetType) {
        Map<Class<?>, Constructor> cachedConstructors = this._getConstructorMapForTarget(targetType);
        if (cachedConstructors == _EMPTY_CONSTRUCTOR_MAP) {
            return _EMPTY_SOURCE_LIST;
        }
        return new ArrayList(cachedConstructors.keySet());
    }

    private Map<Class<?>, Constructor> _getConstructorMapForTarget(Class<?> targetType) {
        Map<Class<?>, Constructor> cachedConstructors = this._cache.get(targetType);
        if (cachedConstructors == null) {
            Constructor<?>[] constructors;
            cachedConstructors = _EMPTY_CONSTRUCTOR_MAP;
            for (Constructor<?> c : constructors = targetType.getConstructors()) {
                Class<?>[] params;
                if (!Modifier.isPublic(c.getModifiers()) || c.getAnnotation(Deprecated.class) != null || (params = c.getParameterTypes()).length != 1) continue;
                if (cachedConstructors == _EMPTY_CONSTRUCTOR_MAP) {
                    cachedConstructors = new HashMap();
                }
                cachedConstructors.put(params[0], c);
            }
            this._cache.put(targetType, cachedConstructors);
        }
        return cachedConstructors;
    }
}

