/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.Scriptlet;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.XhtmlScriptletFactory;

public class AutoSubmitUtils {
    private static final String _AUTO_SUBMIT_SCRIPTLET = "org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AUTO_SUBMIT_SCRIPTLET";
    private static final String _FULL_PAGE_START = "submitForm('";
    private static final String _START = "_adfspu('";
    private static final String _START_RADIO = "_radioSet_adfspu('";
    private static final String _TRUE_END = ");return true;";
    private static final String _FALSE_END = ");return false;";
    private static final String _FIRE_PARTIAL_CHANGE_START = "_firePartialChange('";
    private static final String _FIRE_PARTIAL_CHANGE_END = "');return false;";

    public static void writeDependencies(FacesContext context, RenderingContext arc) throws IOException {
        XhtmlUtils.addLib(context, arc, _AUTO_SUBMIT_SCRIPTLET);
    }

    public static String getParameters(UIComponent comp) {
        int childCount = comp.getChildCount();
        if (childCount == 0) {
            return null;
        }
        StringBuilder builder = null;
        for (UIComponent child : comp.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            String name = param.getName();
            Object value = param.getValue();
            if (value == null || name == null) continue;
            if (builder == null) {
                builder = new StringBuilder();
            }
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append('\'');
            builder.append(XhtmlUtils.escapeJS(name));
            builder.append("':'");
            builder.append(XhtmlUtils.escapeJS(value.toString()));
            builder.append('\'');
        }
        if (builder == null) {
            return null;
        }
        return builder.toString();
    }

    public static String getFullPageSubmitScript(RenderingContext arc, String source, boolean immediate, String event, String extraParams, boolean returnTrue) {
        FormData fData = arc.getFormData();
        if (fData == null) {
            return null;
        }
        String formName = fData.getName();
        if (formName == null) {
            return null;
        }
        String startString = _FULL_PAGE_START;
        String endString = returnTrue ? _TRUE_END : _FALSE_END;
        int length = startString.length() + formName.length() + (event == null ? 0 : event.length() + 9) + (source.length() + 11) + endString.length();
        if (extraParams != null) {
            length += 1 + extraParams.length();
        }
        StringBuilder builder = new StringBuilder(length);
        builder.append(startString);
        builder.append(formName);
        builder.append(immediate ? "',0," : "',1,");
        builder.append("{source:");
        AutoSubmitUtils._appendJSParameter(builder, source);
        if (event != null) {
            builder.append(",event:");
            AutoSubmitUtils._appendJSParameter(builder, event);
        }
        if (extraParams != null) {
            builder.append(",");
            builder.append(extraParams);
        }
        builder.append('}');
        builder.append(endString);
        return builder.toString();
    }

    public static String getPartialGetScript(String destination) {
        int length = _FIRE_PARTIAL_CHANGE_START.length() + _FIRE_PARTIAL_CHANGE_END.length() + destination.length();
        StringBuilder builder = new StringBuilder(length);
        builder.append(_FIRE_PARTIAL_CHANGE_START);
        builder.append(destination);
        builder.append(_FIRE_PARTIAL_CHANGE_END);
        return builder.toString();
    }

    public static String getSubmitScript(RenderingContext arc, String source, boolean immediate) {
        return AutoSubmitUtils.getSubmitScript(arc, source, null, immediate);
    }

    public static String getSubmitScript(RenderingContext arc, String source, String event, boolean immediate) {
        return AutoSubmitUtils.getSubmitScript(arc, source, immediate, false, event, null, true);
    }

    public static String getSubmitScript(RenderingContext arc, String source, boolean immediate, boolean isRadio) {
        return AutoSubmitUtils.getSubmitScript(arc, source, immediate, isRadio, null, null, true);
    }

    public static String getSubmitScript(RenderingContext arc, String source, boolean immediate, boolean isRadio, String event, String extraParams, boolean returnTrue) {
        StringBuilder builder = new StringBuilder();
        FormData formData = arc.getFormData();
        if (formData == null) {
            return null;
        }
        String formName = formData.getName();
        if (formName == null) {
            return null;
        }
        builder.append("TrPage._autoSubmit('");
        builder.append(formName);
        builder.append("',");
        AutoSubmitUtils._appendJSParameter(builder, source);
        boolean isDesktop = arc.getAgent().getType().equals(Agent.TYPE_DESKTOP);
        if (isDesktop) {
            builder.append(",event,");
        } else {
            builder.append(",null,");
        }
        builder.append(immediate ? "0" : "1");
        if (extraParams != null) {
            builder.append(",{");
            builder.append(extraParams);
            builder.append("}");
        }
        builder.append(returnTrue ? _TRUE_END : _FALSE_END);
        return builder.toString();
    }

    private static void _appendJSParameter(StringBuilder builder, String value) {
        if (value == null) {
            builder.append("0");
        } else {
            builder.append("'");
            XhtmlUtils.escapeJS(builder, value, true, 2);
            builder.append("'");
        }
    }

    static {
        XhtmlScriptletFactory.registerAllScriptlets();
        AutoSubmitScriptlet.sharedInstance().registerSelf();
    }

    private static class AutoSubmitScriptlet
    extends Scriptlet {
        private static AutoSubmitScriptlet _sInstance = new AutoSubmitScriptlet();

        private AutoSubmitScriptlet() {
        }

        public static Scriptlet sharedInstance() {
            return _sInstance;
        }

        public Object getScriptletKey() {
            return AutoSubmitUtils._AUTO_SUBMIT_SCRIPTLET;
        }

        protected void outputScriptletContent(FacesContext context, RenderingContext arc) throws IOException {
            if (arc.getFormData() == null) {
                return;
            }
            String formName = arc.getFormData().getName();
            if (formName == null) {
                return;
            }
            ResponseWriter writer = context.getResponseWriter();
            writer.writeText((Object)"var _pprUpDatemode=false;", null);
            writer.writeText((Object)"function _adfspu(f,v,e,s,o){", null);
            writer.writeText((Object)"_pprUpdateMode=true;", null);
            writer.writeText((Object)"if(!o)o=new Object();if(e)o.", null);
            writer.writeText((Object)"event", null);
            writer.writeText((Object)"=e;if(s)o.", null);
            writer.writeText((Object)"source", null);
            writer.writeText((Object)"=s;_submitPartialChange(f,v,o);}", null);
        }
    }
}

