/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.core.nav.CoreBreadCrumbs;
import org.apache.myfaces.trinidad.component.core.nav.CoreCommandLink;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class BreadCrumbsRenderer
extends XhtmlRenderer {
    private PropertyKey _orientationKey;
    private static final int _INDENT_SPACES = 10;
    private static final Map<String, String> _RESOURCE_KEY_MAP = new HashMap<String, String>();

    public BreadCrumbsRenderer() {
        super(CoreBreadCrumbs.TYPE);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._orientationKey = type.findKey("orientation");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", component);
        this.renderAllAttributes(context, arc, bean);
        this.renderId(context, component);
        int renderedItemCount = this._getItemCount((UIXHierarchy)component);
        int minItemCount = this._getMinItemCount(arc);
        if (renderedItemCount > minItemCount) {
            this.renderContent(context, arc, (UIXHierarchy)component, bean);
        }
        writer.endElement("span");
    }

    protected UIComponent getStamp(FacesContext context, RenderingContext arc, UIXHierarchy component, FacesBean bean) {
        UIComponent stamp = component.getFacet("nodeStamp");
        return stamp;
    }

    protected void renderContent(FacesContext context, RenderingContext arc, UIXHierarchy component, FacesBean bean) throws IOException {
        boolean isVertical = this._isVertical(bean);
        boolean shouldRenderLastChild = this.shouldRenderLastChild(arc);
        boolean isLastChild = false;
        boolean isFirstChild = true;
        int renderedCount = 0;
        int nextVisChildIndex = 1;
        UIComponent stamp = this.getStamp(context, arc, component, bean);
        Icon separatorIcon = arc.getIcon("af|breadCrumbs::separator-icon");
        if (stamp != null) {
            Object oldPath = component.getRowKey();
            Object focusPath = this._getFocusRowKey(component);
            if (focusPath == null) {
                return;
            }
            ArrayList<Object> paths = new ArrayList<Object>(component.getAllAncestorContainerRowKeys(focusPath));
            paths.add(focusPath);
            int size = paths.size();
            for (int i = 0; i < size; ++i) {
                nextVisChildIndex = i + 1 == size ? -1 : i + 1;
                isLastChild = nextVisChildIndex == -1;
                component.setRowKey(paths.get(i));
                this.renderNode(context, arc, separatorIcon, stamp, renderedCount, shouldRenderLastChild, isFirstChild, isLastChild, isVertical);
                ++renderedCount;
                isFirstChild = false;
            }
            component.setRowKey(oldPath);
        }
        if (this.hasChildren((UIComponent)component)) {
            List children = component.getChildren();
            nextVisChildIndex = BreadCrumbsRenderer.getNextRenderedChildIndex((List)children, (int)-1);
            while (nextVisChildIndex != -1) {
                UIComponent child = (UIComponent)children.get(nextVisChildIndex);
                isLastChild = (nextVisChildIndex = BreadCrumbsRenderer.getNextRenderedChildIndex((List)children, (int)nextVisChildIndex)) == -1;
                this.renderNode(context, arc, separatorIcon, child, renderedCount, shouldRenderLastChild, isFirstChild, isLastChild, isVertical);
                ++renderedCount;
                isFirstChild = false;
            }
        }
    }

    protected boolean hasChildren(UIComponent component) {
        int childCount = component.getChildCount();
        return childCount > 0;
    }

    protected void renderNode(FacesContext context, RenderingContext arc, Icon separatorIcon, UIComponent child, int renderedCount, boolean shouldRenderLastChild, boolean isFirstChild, boolean isLastChild, boolean isVertical) throws IOException {
        boolean separatorOnNewRow = this.shouldRenderSeparatorOnNewLineWhenVertical(arc);
        if (!isLastChild || shouldRenderLastChild) {
            this.renderStartOfLink(context, isVertical);
            ResponseWriter writer = context.getResponseWriter();
            if (!isFirstChild && isVertical) {
                char[] chars = new char[]{'\u00a0'};
                int indents = separatorOnNewRow ? renderedCount - 1 : renderedCount;
                int indentSpaces = indents * this.getNumberOfIndentSpaces(arc);
                for (int i = 0; i < indentSpaces; ++i) {
                    writer.writeText(chars, 0, 1);
                }
            }
            if (arc.isRightToLeft()) {
                writer.startElement("span", null);
                writer.writeAttribute("dir", (Object)"rtl", null);
            }
            if (!isFirstChild && isVertical && separatorOnNewRow) {
                OutputUtils.renderIcon(context, arc, separatorIcon, "", null);
            }
            this.renderLink(context, arc, child, renderedCount, isLastChild);
            if (!(isLastChild || isVertical && separatorOnNewRow)) {
                OutputUtils.renderIcon(context, arc, separatorIcon, "", null);
            }
            if (arc.isRightToLeft()) {
                writer.endElement("span");
            }
            this.renderEndOfLink(context, isVertical);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderLink(FacesContext context, RenderingContext arc, UIComponent child, int renderedCount, boolean isLastChild) throws IOException {
        if (isLastChild) {
            ((CoreRenderingContext)arc).setLinkDisabled(true);
        }
        boolean isBidi = false;
        String text = BreadCrumbsRenderer.toString(child.getAttributes().get(CoreCommandLink.TEXT_KEY.getName()));
        if (text != null && text.length() > 0) {
            char[] firstChar = new char[]{text.charAt(0)};
            isBidi = Bidi.requiresBidi(firstChar, 0, 1);
        }
        Map originalResourceKeyMap = arc.getSkinResourceKeyMap();
        try {
            arc.setSkinResourceKeyMap(_RESOURCE_KEY_MAP);
            if (!isBidi) {
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("span", null);
                writer.writeAttribute("dir", (Object)"ltr", null);
                this.encodeChild(context, child);
                writer.endElement("span");
            } else {
                this.encodeChild(context, child);
            }
            if (isLastChild) {
                ((CoreRenderingContext)arc).setLinkDisabled(false);
            }
        }
        finally {
            arc.setSkinResourceKeyMap(originalResourceKeyMap);
        }
    }

    protected boolean shouldRenderLastChild(RenderingContext arc) {
        Object propValue = arc.getSkin().getProperty((Object)"af|breadCrumbs-tr-show-last-item");
        return Boolean.TRUE.equals(propValue);
    }

    protected void renderStyleAttributes(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        this.renderStyleAttributes(context, arc, bean, "af|breadCrumbs");
    }

    protected String getOrientation(FacesBean bean) {
        return BreadCrumbsRenderer.toString((Object)bean.getProperty(this._orientationKey));
    }

    protected final void renderStartOfLink(FacesContext context, boolean isVertical) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (isVertical) {
            writer.startElement("div", null);
        }
        writer.startElement("nobr", null);
    }

    protected final void renderEndOfLink(FacesContext context, boolean isVertical) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("nobr");
        if (isVertical) {
            writer.endElement("div");
        }
    }

    private Object _getFocusRowKey(UIXHierarchy component) {
        return component.getFocusRowKey();
    }

    private int _getMinItemCount(RenderingContext arc) {
        int minChildCount = 0;
        boolean shouldRenderLastChild = this.shouldRenderLastChild(arc);
        if (!shouldRenderLastChild) {
            minChildCount = 1;
        }
        return minChildCount;
    }

    private int _getItemCount(UIXHierarchy component) {
        Object focusPath = this._getFocusRowKey(component);
        int kids = BreadCrumbsRenderer.getRenderedChildCount((UIComponent)component);
        if (focusPath == null) {
            return kids;
        }
        return kids + component.getDepth(focusPath) + 1;
    }

    private boolean _isVertical(FacesBean bean) {
        String orientation = this.getOrientation(bean);
        return "vertical".equals(orientation);
    }

    protected boolean shouldRenderSeparatorOnNewLineWhenVertical(RenderingContext arc) {
        Object propValue = arc.getSkin().getProperty((Object)"af|breadCrumbs-tr-separator-on-new-line");
        return Boolean.TRUE.equals(propValue);
    }

    protected int getNumberOfIndentSpaces(RenderingContext arc) {
        Object propValue = arc.getSkin().getProperty((Object)"af|breadCrumbs-tr-indent-spaces");
        int intValue = 10;
        if (propValue != null && propValue instanceof Integer && (intValue = ((Integer)propValue).intValue()) < 0) {
            intValue = 10;
        }
        return intValue;
    }

    static {
        _RESOURCE_KEY_MAP.put("OraLink", "af|breadCrumbs::step");
        _RESOURCE_KEY_MAP.put("OraLinkDisabled", "af|breadCrumbs::selected-step");
    }
}

