/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.UIXNavigationTree;
import org.apache.myfaces.trinidad.component.UIXPage;
import org.apache.myfaces.trinidad.component.UIXTree;
import org.apache.myfaces.trinidad.component.UIXTreeTable;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.FocusEvent;
import org.apache.myfaces.trinidad.event.RowDisclosureEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HiddenLabelUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.TableRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeUtils {
    public static final String EVENT_PARAM = "event";
    public static final String SOURCE_PARAM = "source";
    private static final String _GOTO = "goto";
    private static final String _HIDE = "hide";
    private static final String _SHOW = "show";
    private static final String _FOCUS = "focus";
    private static final String _ALL_VALUE = "all";
    private static final String _PATH_PARAM = "path";
    private static final String _START_PARAM = "start";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TreeUtils.class);

    private TreeUtils() {
    }

    public static void writeNodeLevel(FacesContext context, RenderingContext arc, int depth, String nodeLevelTextKey) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("label", null);
        String pattern = arc.getTranslatedString(nodeLevelTextKey);
        String levelInfo = XhtmlUtils.getFormattedString(pattern, new String[]{IntegerUtils.getString((int)depth)});
        if (HiddenLabelUtils.supportsHiddenLabels(arc)) {
            XhtmlRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"p_OraHiddenLabel");
        }
        writer.writeText((Object)levelInfo, null);
        writer.endElement("label");
    }

    public static Object getFocusRowKey(UIXTreeTable treeTable) {
        Object path = treeTable.getFocusRowKey();
        if (path == null) {
            int oldIndex = treeTable.getRowIndex();
            treeTable.setRowIndex(0);
            Object rowKey = treeTable.getRowKey();
            treeTable.setRowIndex(oldIndex);
            return rowKey;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFocusNodeClientId(FacesContext context, UIXHierarchy tree) {
        String focusNodeClientId = null;
        Object oldRowKey = tree.getRowKey();
        try {
            Object focusRowKey = tree.getFocusRowKey();
            if (focusRowKey != null) {
                tree.setRowKey(focusRowKey);
                focusNodeClientId = tree.getClientId(context);
            }
        }
        finally {
            tree.setRowKey(oldRowKey);
        }
        return focusNodeClientId;
    }

    public static void expandFocusRowKey(UIXTree tree) {
        Object focusRowKey;
        if (!RequestContext.getCurrentInstance().isPostback() && (focusRowKey = tree.getFocusRowKey()) != null) {
            ArrayList<Object> focusPath = new ArrayList<Object>(tree.getAllAncestorContainerRowKeys(focusRowKey));
            focusPath.add(focusRowKey);
            int size = focusPath.size();
            RowKeySet disclosedRowKeys = tree.getDisclosedRowKeys();
            for (int i = 0; i < size; ++i) {
                Object subkey = focusPath.get(i);
                disclosedRowKeys.add(subkey);
            }
        }
    }

    public static void setDefaultFocusRowKey(UIXTree tree) {
        Object path = tree.getFocusRowKey();
        if (path == null) {
            Object oldKey = tree.getRowKey();
            tree.setRowKey(null);
            tree.setRowIndex(0);
            if (tree.isRowAvailable()) {
                tree.setFocusRowKey(tree.getRowKey());
            }
            tree.setRowKey(oldKey);
        }
    }

    public static StringBuffer setupTreeCollectionComponent(StringBuffer buff, boolean validate) {
        String validateString = validate ? "1" : "0";
        buff.append("CollectionComponent.defineTree('event','source','path','start','goto','focus'," + validateString + ");");
        return buff;
    }

    public static String setupJSTreeCollectionComponent(boolean validate) {
        String validateString = validate ? "1" : "0";
        return "CollectionComponent.defineTree('event','source','path','start','goto','focus'," + validateString + ")";
    }

    public static String setupJSMultiSelectCollectionComponent(String selectedKey, String selectedModeKey, boolean autoSubmit) {
        return "CollectionComponent.defineMultiSelect('" + selectedKey + "','" + selectedModeKey + "'," + (autoSubmit ? "true" : "false") + ")";
    }

    public static String createNewJSCollectionComponentState(String formName, String treeClientId) {
        return "new CollectionComponent('" + formName + "','" + treeClientId + "')";
    }

    public static String callJSExpandNode(UIXHierarchy tree, String jsVarName, boolean isExpand) {
        String path = TreeUtils._getPathParam(tree);
        return jsVarName + ".action('" + (isExpand ? _SHOW : _HIDE) + "','" + path + "',this);return false;";
    }

    public static String callJSGotoNode(UIXHierarchy tree, String jsVarName, int rangeStart) {
        String path = TreeUtils._getPathParam(tree);
        return jsVarName + ".range('" + path + "'," + rangeStart + ");return false;";
    }

    public static String callJSFocusNode(UIXHierarchy tree, String jsVarName) {
        String path = TreeUtils._getPathParam(tree);
        return jsVarName + ".focus('" + path + "',this);return false;";
    }

    public static String callJSExpandAll(UIXHierarchy tree, String jsVarName, boolean isExpand) {
        return jsVarName + ".action('" + (isExpand ? _SHOW : _HIDE) + "','" + _ALL_VALUE + "',this);return false;";
    }

    public static String callJSSelectAll(String jsVarName, boolean isSelectAll) {
        return jsVarName + ".multiSelect(" + (isSelectAll ? "true" : "false") + ");return false;";
    }

    public static void decodeGotoEvent(final Map<String, String> parameters, UIComponent tree) {
        String event = parameters.get(EVENT_PARAM);
        if (_GOTO.equals(event)) {
            PreserveState preserve = new PreserveState(){

                protected void process(UIXHierarchy tree) {
                    int newStart;
                    String startParam = (String)parameters.get(TreeUtils._START_PARAM);
                    if (startParam == null || "".equals(startParam)) {
                        startParam = (String)parameters.get("value");
                        newStart = Integer.parseInt(startParam) - 1;
                        tree.setRowKey(tree.getFocusRowKey());
                        tree.setRowIndex(newStart);
                        new FocusEvent((UIComponent)tree).queue();
                    } else {
                        TreeUtils._restorePathFromParam(parameters, tree);
                        newStart = Integer.parseInt(startParam);
                    }
                    TableRenderer.createRangeChangeEvent((CollectionComponent)tree, newStart).queue();
                }
            };
            preserve.run((UIXHierarchy)tree);
        }
    }

    public static void decodeFocusEvent(final Map<String, String> parameters, UIComponent tree) {
        String event = parameters.get(EVENT_PARAM);
        if (_FOCUS.equals(event)) {
            PreserveState preserve = new PreserveState(){

                protected void process(UIXHierarchy tree) {
                    TreeUtils._restorePathFromParam(parameters, tree);
                    new FocusEvent((UIComponent)tree).queue();
                }
            };
            preserve.run((UIXHierarchy)tree);
        }
    }

    public static void decodeExpandEvents(final Map<String, String> parameters, UIComponent tree, final Object focusRowKey) {
        Boolean expand;
        String event = parameters.get(EVENT_PARAM);
        if (_HIDE.equals(event)) {
            expand = Boolean.FALSE;
        } else if (_SHOW.equals(event)) {
            expand = Boolean.TRUE;
        } else {
            return;
        }
        PreserveState preserve = new PreserveState(){

            protected void process(UIXHierarchy tree) {
                RowDisclosureEvent event;
                Object key = parameters.get(TreeUtils._PATH_PARAM);
                if (TreeUtils._ALL_VALUE.equals(key)) {
                    if (focusRowKey == null) {
                        _LOG.severe("UNEXPECTED_TREE_STATE");
                        return;
                    }
                    tree.setRowKey(focusRowKey);
                    RowKeySet old = TreeUtils._getExpandedRowKeys(tree);
                    RowKeySet newset = old.clone();
                    if (expand.booleanValue()) {
                        newset.addAll();
                    } else {
                        newset.removeAll();
                    }
                    event = new RowDisclosureEvent(old, newset, (UIComponent)tree);
                } else {
                    TreeUtils._restorePathFromParam(parameters, tree);
                    RowKeySet old = TreeUtils._getExpandedRowKeys(tree);
                    RowKeySet newset = old.clone();
                    newset.setContained(expand.booleanValue());
                    event = new RowDisclosureEvent(old, newset, (UIComponent)tree);
                }
                event.queue();
            }
        };
        preserve.run((UIXHierarchy)tree);
    }

    public static String renderEncodedNameAttri(FacesContext context, RenderingContext rc, UIXHierarchy tree, String treeName, boolean isExpand) throws IOException {
        return XhtmlUtils.getEncodedNameAttribute(new String[]{SOURCE_PARAM, treeName, EVENT_PARAM, isExpand ? _SHOW : _HIDE, _PATH_PARAM, TreeUtils._getPathParam(tree)});
    }

    private static RowKeySet _getExpandedRowKeys(UIXHierarchy tree) {
        if (tree instanceof UIXTree) {
            return ((UIXTree)tree).getDisclosedRowKeys();
        }
        if (tree instanceof UIXNavigationTree) {
            return ((UIXNavigationTree)tree).getDisclosedRowKeys();
        }
        if (tree instanceof UIXPage) {
            return ((UIXPage)tree).getDisclosedRowKeys();
        }
        throw new IllegalArgumentException("Don't know how to get disclosedRowKeys from:" + tree);
    }

    private static void _restorePathFromParam(Map<String, String> parameters, UIXHierarchy tree) {
        String currencyString = parameters.get(_PATH_PARAM);
        tree.setClientRowKey(currencyString);
    }

    private static String _getPathParam(UIXHierarchy tree) {
        String currencyString = tree.getClientRowKey();
        return currencyString;
    }

    private static abstract class PreserveState {
        private PreserveState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(UIXHierarchy tree) {
            Object oldPath = tree.getRowKey();
            try {
                this.process(tree);
            }
            finally {
                tree.setRowKey(oldPath);
            }
        }

        protected abstract void process(UIXHierarchy var1);
    }
}

