/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.change.ChangeManager;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.apache.myfaces.trinidad.component.UIXIterator;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.w3c.dom.Document;

abstract class BaseChangeManager
extends ChangeManager {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(BaseChangeManager.class);

    BaseChangeManager() {
    }

    public void addComponentChange(FacesContext facesContext, UIComponent uiComponent, ComponentChange change) {
        UIViewRoot root = facesContext.getViewRoot();
        for (UIComponent parent = uiComponent.getParent(); parent != root; parent = parent.getParent()) {
            if (parent.getClass() != UIXIterator.class) continue;
            _LOG.info("DONT_PERSIST_STAMPED_COMPONENT_INSIDE_ITERATOR");
            return;
        }
        if (facesContext == null || uiComponent == null || change == null) {
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_ADD_CHANGE_WITH_FACECONTEXT_OR_UICOMPONENT_OR_NULL"));
        }
        this.addComponentChangeImpl(facesContext, uiComponent, change);
        if (this.supportsDocumentPersistence(facesContext)) {
            DocumentChange docChange = null;
            docChange = change instanceof DocumentChange ? (DocumentChange)((Object)change) : BaseChangeManager.createDocumentChange(change);
            if (docChange != null) {
                this.addDocumentChange(facesContext, uiComponent, docChange);
            }
        }
    }

    protected void addComponentChangeImpl(FacesContext facesContext, UIComponent targetComponent, ComponentChange componentChange) {
    }

    protected void persistDocumentChanges(FacesContext facesContext) {
    }

    protected abstract Document getDocument(FacesContext var1);

    protected boolean supportsDocumentPersistence(FacesContext context) {
        return this.getDocument(context) != null;
    }
}

