/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import org.apache.myfaces.trinidad.context.DialogService;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.LaunchEvent;
import org.apache.myfaces.trinidad.event.ReturnEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.DialogRenderKitService;
import org.apache.myfaces.trinidad.util.Service;
import org.apache.myfaces.trinidadinternal.application.StateManagerImpl;
import org.apache.myfaces.trinidadinternal.context.RequestContextImpl;
import org.apache.myfaces.trinidadinternal.webapp.TrinidadFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogServiceImpl
extends DialogService {
    public static final String DIALOG_RETURN = "org.apache.myfaces.trinidad.DialogReturn";
    private RequestContextImpl _context;
    private static final String _PUSHED_VIEWS_KEY = "org.apache.myfaces.trinidadinternal.PushedViews";
    private static final String _DIALOG_RETURN_KEY = "org.apache.myfaces.trinidadinternal.DialogReturnValue";
    private static final String _USED_RENDER_KIT_KEY = "org.apache.myfaces.trinidadinternal.DialogUsedRK";
    private static final String _RETURN_PARAM = "org.apache.myfaces.trinidadinternal.ReturnParam";
    private static final String _TARGET_FOR_STATE_TOKEN = "org.apache.myfaces.trinidadinternal.StateToken";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(DialogServiceImpl.class);

    public DialogServiceImpl(RequestContextImpl context) {
        this._context = context;
    }

    public void pushView(UIViewRoot viewRoot) {
        FacesContext context = this._getFacesContext();
        Object savedOld = StateManagerImpl.saveViewRoot(context, viewRoot);
        ArrayList<Object> list = (ArrayList<Object>)this._getPageFlowScope().get(_PUSHED_VIEWS_KEY);
        if (list == null) {
            list = new ArrayList<Object>(1);
        } else {
            ArrayList<Object> tmp = new ArrayList<Object>(list.size() + 1);
            tmp.addAll(list);
            list = tmp;
        }
        list.add(savedOld);
        this._getPageFlowScope().put(_PUSHED_VIEWS_KEY, list);
        _LOG.fine("Pushed view {0}", (Object)viewRoot.getViewId());
    }

    public void popView(boolean navigateToPoppedView) {
        ArrayList list;
        FacesContext context = this._getFacesContext();
        if (navigateToPoppedView) {
            UIViewRoot poppedView = this.peekView();
            if (poppedView == null) {
                throw new IllegalStateException(_LOG.getMessage("POPVIEW_NO_VIEW_PUSHED"));
            }
            context.setViewRoot(poppedView);
            this._executeBindings(context, (UIComponent)poppedView);
            _LOG.fine("Popped view {0}", (Object)poppedView.getViewId());
        }
        if ((list = (ArrayList)this._getPageFlowScope().get(_PUSHED_VIEWS_KEY)) == null) {
            assert (!navigateToPoppedView);
            throw new IllegalStateException(_LOG.getMessage(">POPVIEW_NO_VIEW_PUSHED"));
        }
        if (list.size() == 1) {
            this._getPageFlowScope().remove(_PUSHED_VIEWS_KEY);
        } else {
            list = new ArrayList(list);
            list.remove(list.size() - 1);
            this._getPageFlowScope().put(_PUSHED_VIEWS_KEY, list);
        }
    }

    public UIViewRoot peekView() {
        FacesContext context = this._getFacesContext();
        Object savedRoot = null;
        List list = (List)this._getPageFlowScope().get(_PUSHED_VIEWS_KEY);
        if (list != null) {
            savedRoot = list.get(list.size() - 1);
        }
        if (savedRoot == null) {
            return null;
        }
        try {
            return StateManagerImpl.restoreViewRoot(context, savedRoot);
        }
        catch (ClassNotFoundException cnfe) {
            _LOG.severe((Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            _LOG.severe((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            _LOG.severe((Throwable)iae);
        }
        return null;
    }

    public boolean returnFromDialog(Object returnValue, Map<Object, Object> returnParameters) {
        DialogRenderKitService service;
        FacesContext context = this._getFacesContext();
        context.getExternalContext().getSessionMap().put(_DIALOG_RETURN_KEY, new Object[]{returnValue, returnParameters});
        Object usedRenderKit = this._getPageFlowScope().get(_USED_RENDER_KIT_KEY);
        if (usedRenderKit == null) {
            _LOG.warning("RETURNFROMDIALOG_KEY_NOT_AVAILABLE");
        }
        if (Boolean.TRUE.equals(usedRenderKit) && (service = DialogServiceImpl._getDialogRenderKitService(context)) != null && service.returnFromDialog(context, returnValue)) {
            return true;
        }
        this.popView(true);
        UIViewRoot poppedView = context.getViewRoot();
        Map launchParameters = (Map)poppedView.getAttributes().get("org.apache.myfaces.trinidad.PageFlowSourceParameters");
        Map requestMap = context.getExternalContext().getRequestMap();
        if (launchParameters != null) {
            poppedView.getAttributes().remove("org.apache.myfaces.trinidad.PageFlowSourceParameters");
            requestMap.put("org.apache.myfaces.trinidad.PageFlowSourceParameters", launchParameters);
            requestMap.put("org.apache.myfaces.trinidad.PageFlowSourceView", poppedView);
            context.responseComplete();
            _LOG.fine("Returned from dialog and re-executing lifecycle for {0}", (Object)poppedView.getViewId());
        }
        requestMap.put(DIALOG_RETURN, Boolean.TRUE);
        return false;
    }

    public ReturnEvent getReturnEvent(UIComponent source) {
        FacesContext context = this._getFacesContext();
        if (TrinidadFilterImpl.isExecutingDialogReturn(context)) {
            Map parameterMap = context.getExternalContext().getRequestParameterMap();
            String returnParam = (String)parameterMap.get(_RETURN_PARAM);
            if (returnParam == null) {
                return null;
            }
            String clientId = source.getClientId(context);
            if (!returnParam.equals(clientId)) {
                return null;
            }
        } else {
            DialogRenderKitService service = DialogServiceImpl._getDialogRenderKitService(context);
            if (service == null) {
                return null;
            }
            if (!service.isReturning(context, source)) {
                return null;
            }
        }
        Object o = context.getExternalContext().getSessionMap().remove(_DIALOG_RETURN_KEY);
        Object returnValue = null;
        Map returnParams = null;
        if (o != null) {
            returnValue = ((Object[])o)[0];
            returnParams = (Map)((Object[])o)[1];
        }
        ReturnEvent returnEvent = new ReturnEvent(source, returnValue, returnParams);
        if (_LOG.isFine()) {
            _LOG.fine("Obtained ReturnEvent {0}", (Object)returnEvent);
        }
        return returnEvent;
    }

    public void queueLaunchEvent(UIViewRoot viewRoot) {
        UIComponent source = this.getCurrentLaunchSource();
        if (source == null) {
            this.launchDialog(viewRoot, null, null, false, null);
        } else {
            new InternalLaunch(source, viewRoot).queue();
        }
    }

    public void queueReturnEvent(Object returnValue, Map<Object, Object> returnParams) {
        UIComponent source = this.getCurrentLaunchSource();
        if (source == null) {
            _LOG.warning("CANNOT_QUEUE_RETURN_EVENT");
        } else {
            new ReturnEvent(source, returnValue, returnParams).queue();
        }
    }

    public static void writeCurrentStateToken(FacesContext context, String token) {
        String[] targetForToken;
        if (token == null) {
            return;
        }
        Object o = context.getExternalContext().getRequestMap().get(_TARGET_FOR_STATE_TOKEN);
        if (o instanceof String[] && (targetForToken = (String[])o).length == 1) {
            targetForToken[0] = token;
        }
    }

    public static void pinPriorState(FacesContext context) {
        String token;
        String[] targetForToken;
        RequestContext rc = RequestContext.getCurrentInstance();
        Object o = rc.getPageFlowScope().get(_TARGET_FOR_STATE_TOKEN);
        if (o instanceof String[] && (targetForToken = (String[])o).length == 1 && (token = targetForToken[0]) != null) {
            StateManagerImpl.pinStateToRequest(context, token);
        }
    }

    public void launchDialog(UIViewRoot dialogRoot, Map<String, Object> dialogParameters, UIComponent source, boolean useWindow, Map<String, Object> windowProperties) {
        if (dialogParameters == null) {
            dialogParameters = new HashMap<String, Object>();
        }
        FacesContext context = this._getFacesContext();
        UIViewRoot sourceRoot = context.getViewRoot();
        dialogParameters.put(_USED_RENDER_KIT_KEY, Boolean.TRUE);
        String[] targetForToken = new String[1];
        dialogParameters.put(_TARGET_FOR_STATE_TOKEN, targetForToken);
        DialogRenderKitService service = DialogServiceImpl._getDialogRenderKitService(context);
        if (service != null && service.launchDialog(context, dialogRoot, source, dialogParameters, useWindow, windowProperties)) {
            _LOG.fine("Launched {0} dialog using RenderKit", (Object)dialogRoot.getViewId());
            this._context.getPageFlowScopeProvider().popPageFlowScope(context, false);
            context.getExternalContext().getRequestMap().put(_TARGET_FOR_STATE_TOKEN, targetForToken);
        } else {
            _LOG.fine("Launching {0} dialog via fallback mechanism", (Object)dialogRoot.getViewId());
            dialogParameters.put(_USED_RENDER_KIT_KEY, Boolean.FALSE);
            HashMap<String, String[]> savedRequestParameters = new HashMap<String, String[]>();
            savedRequestParameters.putAll(context.getExternalContext().getRequestParameterValuesMap());
            if (source != null) {
                savedRequestParameters.put(_RETURN_PARAM, new String[]{source.getClientId(context)});
            } else {
                savedRequestParameters.remove(_RETURN_PARAM);
            }
            savedRequestParameters.remove("source");
            savedRequestParameters.remove("event");
            sourceRoot.getAttributes().put("org.apache.myfaces.trinidad.PageFlowSourceParameters", savedRequestParameters);
            this.pushView(sourceRoot);
            this._getPageFlowScope().putAll(dialogParameters);
            context.setViewRoot(dialogRoot);
            context.renderResponse();
        }
    }

    private FacesContext _getFacesContext() {
        return this._context.__getFacesContext();
    }

    private Map<String, Object> _getPageFlowScope() {
        return this._context.getPageFlowScope();
    }

    private static DialogRenderKitService _getDialogRenderKitService(FacesContext context) {
        RenderKit rk = context.getRenderKit();
        DialogRenderKitService service = (DialogRenderKitService)Service.getService((Object)rk, DialogRenderKitService.class);
        if (service == null) {
            _LOG.info("RENDERKIT_NOT_SUPPORT_DIALOGRENDERKITSERVICE", (Object)rk);
        }
        return service;
    }

    private void _executeBindings(FacesContext context, UIComponent component) {
        ValueExpression expression = component.getValueExpression("binding");
        if (expression != null) {
            expression.setValue(context.getELContext(), (Object)component);
        }
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            this._executeBindings(context, (UIComponent)kids.next());
        }
    }

    private static class InternalLaunch
    extends LaunchEvent {
        private static final long serialVersionUID = -8586594511769079566L;

        public InternalLaunch(UIComponent source, UIViewRoot viewRoot) {
            super(source, viewRoot);
        }

        public void launchDialog(boolean useWindow) {
            RequestContext afContext = RequestContext.getCurrentInstance();
            afContext.getDialogService().launchDialog(this.getViewRoot(), this.getDialogParameters(), this.getComponent(), useWindow, this.getWindowProperties());
        }
    }
}

