/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ValueExpression;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidadinternal.taglib.util.VirtualAttributeUtils;
import org.apache.myfaces.trinidadinternal.util.nls.StringUtils;

final class AccessKeyPropertyTagRule
extends MetaRule {
    public static final MetaRule Instance = new AccessKeyPropertyTagRule();

    AccessKeyPropertyTagRule() {
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (name.endsWith("AndAccessKey")) {
            String mainProperty = name.substring(0, name.length() - "AndAccessKey".length());
            Method mainM = meta.getWriteMethod(mainProperty);
            Method accessKeyM = meta.getWriteMethod("accessKey");
            if (mainM != null && accessKeyM != null) {
                if (attribute.isLiteral()) {
                    return new LiteralAccessKeyMetadata(mainM, accessKeyM, attribute);
                }
                return new AccessKeyMetadata(mainProperty, attribute);
            }
        }
        return null;
    }

    private static class LiteralAccessKeyMetadata
    extends Metadata {
        private final Method _mainMethod;
        private final Method _accessKeyMethod;
        private final TagAttribute _attribute;
        private final String _text;
        private final Character _accessKey;

        public LiteralAccessKeyMetadata(Method mainMethod, Method accessKeyMethod, TagAttribute attribute) {
            this._mainMethod = mainMethod;
            this._accessKeyMethod = accessKeyMethod;
            String text = attribute.getValue();
            int accessKeyIndex = StringUtils.getMnemonicIndex(text);
            if (accessKeyIndex != -1) {
                this._accessKey = Character.valueOf(text.charAt(accessKeyIndex + 1));
                text = StringUtils.stripMnemonic(text);
            } else {
                this._accessKey = null;
            }
            this._text = text;
            this._attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            try {
                if (this._accessKey != null) {
                    this._accessKeyMethod.invoke(instance, this._accessKey);
                }
                this._mainMethod.invoke(instance, this._text);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }

    private static class AccessKeyMetadata
    extends Metadata {
        private final String _mainMethodName;
        private final TagAttribute _attribute;

        public AccessKeyMetadata(String mainMethodName, TagAttribute attribute) {
            this._mainMethodName = mainMethodName;
            this._attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ValueExpression expr = this._attribute.getValueExpression(ctx, String.class);
            UIXComponent uixcomp = (UIXComponent)instance;
            FacesBean bean = uixcomp.getFacesBean();
            PropertyKey mainKey = bean.getType().findKey(this._mainMethodName);
            if (mainKey == null) {
                throw new TagAttributeException(this._attribute, "No support for '" + this._mainMethodName + "' attribute on " + instance);
            }
            PropertyKey accessKeyKey = bean.getType().findKey("accessKey");
            if (accessKeyKey == null) {
                throw new TagAttributeException(this._attribute, "No support for 'accessKey' attribute on " + instance);
            }
            VirtualAttributeUtils.setAccessKeyAttribute(bean, expr, mainKey, accessKeyKey);
        }
    }
}

