/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.encode;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.image.painter.ImageLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PNGEncoder {
    private static final byte[] _SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int _IHDR = 1229472850;
    private static final int _PLTE = 1347179589;
    private static final int _IDAT = 1229209940;
    private static final int _IEND = 1229278788;
    private static final int _tRNS = 1951551059;
    private static final byte[] _TRANSPARENT_DATA = new byte[]{0};
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PNGEncoder.class);

    public static void encode(Image image, OutputStream out) throws IOException {
        ImageLoader loader = new ImageLoader(image);
        loader.start();
        if (!loader.waitFor()) {
            throw new IllegalArgumentException(_LOG.getMessage("PROBLEM_LOADING"));
        }
        int width = image.getWidth(loader);
        int height = image.getHeight(loader);
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(image.getSource(), 0, 0, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            throw new IllegalArgumentException(_LOG.getMessage("GRABBING_PIXELS"));
        }
        if ((grabber.getStatus() & 0x80) != 0) {
            throw new IllegalArgumentException(_LOG.getMessage("ERROR_FETCHING_IMAGE", new Object[]{pixels.length, width, height}));
        }
        Hashtable<Color, Integer> colors = new Hashtable<Color, Integer>();
        int count = 0;
        Color lastColor = null;
        int lastPixel = -2;
        Color firstColor = PNGEncoder._createColor(pixels[0]);
        Color transparentColor = null;
        for (int i = 0; i < pixels.length; ++i) {
            int pixel = pixels[i];
            if (pixel == lastPixel && lastColor != null) continue;
            Color color = PNGEncoder._createColor(pixel);
            if (!colors.containsKey(color)) {
                if (color.getAlpha() == 0 && transparentColor == null) {
                    colors.put(color, 0);
                    colors.put(firstColor, count);
                    transparentColor = color;
                } else {
                    colors.put(color, count);
                }
                ++count;
            }
            lastPixel = pixel;
            lastColor = color;
        }
        boolean transparent = transparentColor != null;
        PNGEncoder._writeSignature(out);
        if (count <= 256) {
            PNGEncoder._writePaletteImage(width, height, pixels, colors, transparent, out);
        } else {
            PNGEncoder._writeRGBImage(width, height, pixels, out);
        }
        PNGEncoder._writeEnd(out);
    }

    private PNGEncoder() {
    }

    private static void _writePaletteImage(int width, int height, int[] pixels, Map<Color, Integer> colors, boolean transparent, OutputStream out) throws IOException {
        int count = colors.size();
        assert (count <= 256);
        int depth = 8;
        PNGEncoder._writeHeader(width, height, (byte)depth, (byte)3, out);
        PNGEncoder._writePalette(colors, out);
        if (transparent) {
            PNGEncoder._writeTransparency(out);
        }
        byte[] data = PNGEncoder._getIndexedData(width, height, depth, pixels, colors);
        PNGEncoder._writeData(data, out);
    }

    private static void _writeRGBImage(int width, int height, int[] pixels, OutputStream out) throws IOException {
        PNGEncoder._writeHeader(width, height, (byte)8, (byte)2, out);
        byte[] data = new byte[pixels.length * 3 + height];
        int sourceLine = 0;
        int targetLine = 0;
        for (int i = 0; i < height; ++i) {
            data[targetLine] = 0;
            for (int j = 0; j < width; ++j) {
                int pixel = pixels[sourceLine + j];
                int target = targetLine + j * 3 + 1;
                data[target] = PNGEncoder._getRed(pixel);
                data[target + 1] = PNGEncoder._getGreen(pixel);
                data[target + 2] = PNGEncoder._getBlue(pixel);
            }
            sourceLine += width;
            targetLine += width * 3 + 1;
        }
        PNGEncoder._writeData(data, out);
    }

    private static void _writeData(byte[] data, OutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream deflater = new DeflaterOutputStream(baos);
        ((OutputStream)deflater).write(data);
        ((OutputStream)deflater).flush();
        ((OutputStream)deflater).close();
        PNGEncoder._writeChunk(1229209940, baos.toByteArray(), out);
    }

    private static void _writeEnd(OutputStream out) throws IOException {
        PNGEncoder._writeChunk(1229278788, null, out);
    }

    private static void _writeHeader(int width, int height, byte depth, byte type, OutputStream out) throws IOException {
        byte[] data = new byte[13];
        PNGEncoder._writeInt(width, 0, data);
        PNGEncoder._writeInt(height, 4, data);
        data[8] = depth;
        data[9] = type;
        data[10] = 0;
        data[11] = 0;
        data[12] = 0;
        PNGEncoder._writeChunk(1229472850, data, out);
    }

    private static void _writePalette(Map<Color, Integer> colors, OutputStream out) throws IOException {
        int count = colors.size();
        byte[] data = new byte[count * 3];
        for (Map.Entry<Color, Integer> entry : colors.entrySet()) {
            Color color = entry.getKey();
            int index = entry.getValue() * 3;
            int rgb = color.getRGB();
            data[index] = PNGEncoder._getRed(rgb);
            data[index + 1] = PNGEncoder._getGreen(rgb);
            data[index + 2] = PNGEncoder._getBlue(rgb);
        }
        PNGEncoder._writeChunk(1347179589, data, out);
    }

    private static void _writeSignature(OutputStream out) throws IOException {
        out.write(_SIGNATURE);
    }

    private static void _writeTransparency(OutputStream out) throws IOException {
        PNGEncoder._writeChunk(1951551059, _TRANSPARENT_DATA, out);
    }

    private static void _writeChunk(int type, byte[] data, OutputStream out) throws IOException {
        int length = data == null ? 0 : data.length;
        PNGEncoder._writeInt(length, out);
        PNGEncoder._writeInt(type, out);
        if (data != null) {
            out.write(data);
        }
        PNGEncoder._write32(PNGEncoder._getCRC(type, data), out);
    }

    private static void _writeInt(int i, OutputStream out) throws IOException {
        out.write(i >> 24 & 0xFF);
        out.write(i >> 16 & 0xFF);
        out.write(i >> 8 & 0xFF);
        out.write(i & 0xFF);
    }

    private static void _writeInt(int i, int offset, byte[] buffer) throws IOException {
        buffer[offset] = (byte)(i >> 24 & 0xFF);
        buffer[offset + 1] = (byte)(i >> 16 & 0xFF);
        buffer[offset + 2] = (byte)(i >> 8 & 0xFF);
        buffer[offset + 3] = (byte)(i & 0xFF);
    }

    private static void _write32(long l, OutputStream out) throws IOException {
        out.write((int)(l >> 24) & 0xFF);
        out.write((int)(l >> 16) & 0xFF);
        out.write((int)(l >> 8) & 0xFF);
        out.write((int)l & 0xFF);
    }

    private static long _getCRC(int type, byte[] data) {
        CRC32 crc = new CRC32();
        crc.update(type >> 24 & 0xFF);
        crc.update(type >> 16 & 0xFF);
        crc.update(type >> 8 & 0xFF);
        crc.update(type & 0xFF);
        if (data != null) {
            crc.update(data);
        }
        return crc.getValue();
    }

    private static byte[] _getIndexedData(int width, int height, int depth, int[] pixels, Map<Color, Integer> colors) {
        assert (depth == 8);
        return PNGEncoder._getIndexedData8(width, height, pixels, colors);
    }

    private static byte[] _getIndexedData8(int width, int height, int[] pixels, Map<Color, Integer> colors) {
        byte[] data = new byte[pixels.length + height];
        int sourceLine = 0;
        int targetLine = 0;
        Color lastColor = null;
        int lastPixel = -2;
        for (int i = 0; i < height; ++i) {
            data[targetLine] = 0;
            for (int j = 0; j < width; ++j) {
                int pixel = pixels[sourceLine + j];
                Color color = pixel == lastPixel && lastColor != null ? lastColor : PNGEncoder._createColor(pixel);
                int index = colors.get(color);
                data[targetLine + j + 1] = (byte)index;
                lastPixel = pixel;
                lastColor = color;
            }
            sourceLine += width;
            targetLine += width + 1;
        }
        return data;
    }

    private static final Color _createColor(int argb) {
        if ((argb & 0xFF000000) != 0) {
            return new Color(argb | 0xFF000000);
        }
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return new Color(r, g, b, a);
    }

    private static byte _getRed(int c) {
        return (byte)(c >> 16 & 0xFF);
    }

    private static byte _getGreen(int c) {
        return (byte)(c >> 8 & 0xFF);
    }

    private static byte _getBlue(int c) {
        return (byte)(c & 0xFF);
    }
}

