/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidad.validator.ValidatorUtils;

public class RegExpValidator
implements StateHolder,
Validator {
    public static final String VALIDATOR_ID = "org.apache.myfaces.trinidad.RegExp";
    public static final String NO_MATCH_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.RegExpValidator.NO_MATCH";
    private static final FacesBean.Type _TYPE = new FacesBean.Type();
    private static final PropertyKey _PATTERN_KEY = _TYPE.registerKey("pattern", String.class);
    private static final PropertyKey _NO_MATCH_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailNoMatch", String.class);
    private static final PropertyKey _HINT_PATTERN_KEY = _TYPE.registerKey("hint", String.class);
    private FacesBean _facesBean = ValidatorUtils.getFacesBean(_TYPE);
    private transient Pattern _compiled;
    private boolean _isTransient = false;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RegExpValidator.class);

    public RegExpValidator() {
    }

    public RegExpValidator(String pattern) {
        this.setPattern(pattern);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_FACESCONTEXT_OR_UICOMPONENT"));
        }
        if (value != null) {
            String theValue;
            Matcher matcher;
            ValidatorUtils.assertIsString(value, "'value' is not of type java.lang.String.");
            if (this.getPattern() == null) {
                throw new NullPointerException(_LOG.getMessage("NULL_REGEXP_PATTERN"));
            }
            if (this._compiled == null) {
                this._compiled = Pattern.compile(this.getPattern());
            }
            if (!(matcher = this._compiled.matcher(theValue = (String)value)).matches()) {
                throw new ValidatorException(this._getNoMatchFoundMessage(context, component, theValue));
            }
        }
    }

    public boolean isTransient() {
        return this._isTransient;
    }

    public void setTransient(boolean transientValue) {
        this._isTransient = transientValue;
    }

    public Object saveState(FacesContext context) {
        return this._facesBean.saveState(context);
    }

    public void restoreState(FacesContext context, Object state) {
        this._facesBean.restoreState(context, state);
    }

    public void setValueExpression(String name, ValueExpression expression) {
        ValidatorUtils.setValueExpression(this._facesBean, name, expression);
    }

    public ValueExpression getValueExpression(String name) {
        return ValidatorUtils.getValueExpression(this._facesBean, name);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        ValidatorUtils.setValueBinding(this._facesBean, name, binding);
    }

    public ValueBinding getValueBinding(String name) {
        return ValidatorUtils.getValueBinding(this._facesBean, name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RegExpValidator) {
            RegExpValidator other = (RegExpValidator)object;
            if (this.isTransient() == other.isTransient() && ValidatorUtils.equals(this.getPattern(), other.getPattern()) && ValidatorUtils.equals(this.getMessageDetailNoMatch(), other.getMessageDetailNoMatch())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        String pattern = this.getPattern();
        String noMesgDetail = this.getMessageDetailNoMatch();
        result = 37 * result + (pattern == null ? 0 : pattern.hashCode());
        result = 37 * result + (this.isTransient() ? 0 : 1);
        result = 37 * result + (noMesgDetail == null ? 0 : noMesgDetail.hashCode());
        return result;
    }

    public void setHint(String hintPattern) {
        this._facesBean.setProperty(_HINT_PATTERN_KEY, hintPattern);
    }

    public String getHint() {
        Object obj = this._facesBean.getProperty(_HINT_PATTERN_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setPattern(String pattern) {
        String prevPattern = this.getPattern();
        if (prevPattern != null && prevPattern.equals(pattern)) {
            return;
        }
        if (prevPattern == null && pattern == null) {
            return;
        }
        this._facesBean.setProperty(_PATTERN_KEY, pattern);
        this._compiled = null;
    }

    public String getPattern() {
        Object obj = this._facesBean.getProperty(_PATTERN_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setMessageDetailNoMatch(String noMatchMessageDetail) {
        this._facesBean.setProperty(_NO_MATCH_MESSAGE_DETAIL_KEY, noMatchMessageDetail);
    }

    public String getMessageDetailNoMatch() {
        Object obj = this._facesBean.getProperty(_NO_MATCH_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(obj);
    }

    private FacesMessage _getNoMatchFoundMessage(FacesContext context, UIComponent component, String value) {
        Object noMatchMsgDet = this._getRawNoMatchMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, value, this.getPattern()};
        FacesMessage msg = MessageFactory.getMessage(context, NO_MATCH_MESSAGE_ID, noMatchMsgDet, params, label);
        return msg;
    }

    private Object _getRawNoMatchMessageDetail() {
        return this._facesBean.getRawProperty(_NO_MATCH_MESSAGE_DETAIL_KEY);
    }
}

