/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.webapp;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentELTag;
import javax.servlet.jsp.JspException;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.change.ChangeManager;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.UIXDocument;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIXComponentELTag
extends UIComponentELTag {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXComponentELTag.class);
    public static final String DOCUMENT_CREATED_KEY = "org.apache.myfaces.trinidad.DOCUMENTCREATED";
    private MethodExpression _attributeChangeListener;
    private String _validationError;

    public void setAttributeChangeListener(MethodExpression attributeChangeListener) {
        this._attributeChangeListener = attributeChangeListener;
    }

    public int doStartTag() throws JspException {
        int retVal = super.doStartTag();
        if (this._validationError != null) {
            throw new JspException(this._validationError);
        }
        return retVal;
    }

    public int doEndTag() throws JspException {
        UIComponent component = this.getComponentInstance();
        if (component instanceof UIXDocument) {
            if (this.getCreated()) {
                ExternalContext ec = FacesContext.getCurrentInstance().getExternalContext();
                ec.getRequestMap().put(DOCUMENT_CREATED_KEY, Boolean.TRUE);
            }
            ChangeManager cm = RequestContext.getCurrentInstance().getChangeManager();
            cm.applyComponentChangesForCurrentView(FacesContext.getCurrentInstance());
        }
        return super.doEndTag();
    }

    protected final void setProperties(UIComponent component) {
        if (component instanceof UIViewRoot) {
            throw new IllegalStateException("<f:view> was not present on this page; tag " + (Object)((Object)this) + "encountered without an <f:view> being processed.");
        }
        super.setProperties(component);
        UIXComponent uixComponent = (UIXComponent)component;
        if (this._attributeChangeListener != null) {
            uixComponent.setAttributeChangeListener(this._attributeChangeListener);
        }
        this.setProperties(uixComponent.getFacesBean());
    }

    protected void setProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            bean.setProperty(key, expression.getValue(null));
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setStringArrayProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            bean.setProperty(key, UIXComponentELTag._parseNameTokens(expression.getValue(null)));
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setStringListProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            bean.setProperty(key, UIXComponentELTag._parseNameTokensAsList(expression.getValue(null)));
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setStringSetProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            bean.setProperty(key, UIXComponentELTag._parseNameTokensAsSet(expression.getValue(null)));
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setNumberProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            Object value = expression.getValue(null);
            if (value != null) {
                if (value instanceof Number) {
                    bean.setProperty(key, value);
                } else {
                    String valueStr = value.toString();
                    if (valueStr.indexOf(46) == -1) {
                        bean.setProperty(key, Integer.valueOf(valueStr));
                    } else {
                        bean.setProperty(key, Double.valueOf(valueStr));
                    }
                }
            }
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setIntArrayProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            String[] strings;
            Object value = expression.getValue(null);
            if (value != null && (strings = UIXComponentELTag._parseNameTokens(value)) != null) {
                try {
                    int[] ints = new int[strings.length];
                    for (int i = 0; i < strings.length; ++i) {
                        int j;
                        ints[i] = j = Integer.parseInt(strings[i]);
                    }
                }
                catch (NumberFormatException e) {
                    _LOG.severe("CANNOT_CONVERT_INTO_INT_ARRAY", value);
                    _LOG.severe(e);
                    return;
                }
            }
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setDateProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            bean.setProperty(key, UIXComponentELTag._parseISODate(expression.getValue(null)));
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setMaxDateProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            Date d = UIXComponentELTag._parseISODate(expression.getValue(null));
            Calendar c = Calendar.getInstance();
            TimeZone tz = RequestContext.getCurrentInstance().getTimeZone();
            if (tz != null) {
                c.setTimeZone(tz);
            }
            c.setTime(d);
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            c.set(14, 999);
            bean.setProperty(key, c.getTime());
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setProperties(FacesBean bean) {
    }

    protected void setValidationError(String validationError) {
        this._validationError = validationError;
    }

    private static final Date _parseISODate(Object o) {
        if (o == null) {
            return null;
        }
        String stringValue = o.toString();
        try {
            return UIXComponentELTag._getDateFormat().parse(stringValue);
        }
        catch (ParseException pe) {
            _LOG.info("CANNOT_PARSE_VALUE_INTO_DATE", stringValue);
            return null;
        }
    }

    private static final String[] _parseNameTokens(Object o) {
        List<String> list = UIXComponentELTag._parseNameTokensAsList(o);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    private static final List<String> _parseNameTokensAsList(Object o) {
        if (o == null) {
            return null;
        }
        String stringValue = o.toString();
        ArrayList<String> list = new ArrayList<String>(5);
        int length = stringValue.length();
        boolean inSpace = true;
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char ch = stringValue.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (inSpace) continue;
                list.add(stringValue.substring(start, i));
                inSpace = true;
                continue;
            }
            if (!inSpace) continue;
            start = i;
            inSpace = false;
        }
        if (!inSpace) {
            list.add(stringValue.substring(start));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private static final Set<String> _parseNameTokensAsSet(Object o) {
        List<String> list = UIXComponentELTag._parseNameTokensAsList(o);
        if (list == null) {
            return null;
        }
        return new HashSet<String>(list);
    }

    private static DateFormat _getDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        TimeZone tz = RequestContext.getCurrentInstance().getTimeZone();
        if (tz != null) {
            sdf.setTimeZone(tz);
        }
        return sdf;
    }
}

