/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.application;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;

final class Structure
implements Externalizable {
    private String _class;
    private String _id;
    private List<Object> _facets;
    private List<Structure> _children;
    private static final String _COMMON_CLASS_PREFIX = "org.apache.myfaces.trinidad.component";
    private static final int _COMMON_CLASS_PREFIX_LENGTH = "org.apache.myfaces.trinidad.component".length();
    private static final long serialVersionUID = 1L;

    public Structure() {
    }

    public Structure(UIComponent component) {
        this._class = component.getClass().getName();
        this._id = component.getId();
        this._facets = this._getFacets(component);
        this._children = this._getChildren(component);
    }

    public UIComponent createComponent() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        int i;
        Class clazz = ClassLoaderUtils.loadClass((String)this._class);
        UIComponent component = (UIComponent)clazz.newInstance();
        if (this._id != null) {
            component.setId(this._id);
        }
        if (this._facets != null) {
            Map facets = component.getFacets();
            for (i = 0; i < this._facets.size(); i += 2) {
                UIComponent facet = ((Structure)this._facets.get(i + 1)).createComponent();
                facets.put((String)this._facets.get(i), facet);
            }
        }
        if (this._children != null) {
            List children = component.getChildren();
            for (i = 0; i < this._children.size(); ++i) {
                UIComponent child = this._children.get(i).createComponent();
                children.add(child);
            }
        }
        return component;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeObject(Structure._abbreviateClass(this._class));
        out.writeObject(this._id);
        if (this._facets == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this._facets.size());
            for (i = 0; i < this._facets.size(); i += 2) {
                out.writeObject(this._facets.get(i));
                ((Structure)this._facets.get(i + 1)).writeExternal(out);
            }
        }
        if (this._children == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this._children.size());
            for (i = 0; i < this._children.size(); ++i) {
                this._children.get(i).writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int childCount;
        this._class = Structure._unabbreviateClass((String)in.readObject());
        this._id = (String)in.readObject();
        int facetCount = in.readShort();
        if (facetCount > 0) {
            this._facets = new ArrayList<Object>(facetCount);
            for (int i = 0; i < facetCount; i += 2) {
                this._facets.add(in.readObject());
                Structure newStruct = new Structure();
                newStruct.readExternal(in);
                this._facets.add(newStruct);
            }
        }
        if ((childCount = in.readShort()) > 0) {
            this._children = new ArrayList<Structure>(childCount);
            for (int i = 0; i < childCount; ++i) {
                Structure newStruct = new Structure();
                newStruct.readExternal(in);
                this._children.add(newStruct);
            }
        }
    }

    private List<Structure> _getChildren(UIComponent component) {
        if (component.getChildCount() == 0) {
            return null;
        }
        List children = component.getChildren();
        ArrayList<Structure> list = new ArrayList<Structure>(children.size());
        for (UIComponent child : children) {
            if (child == null || child.isTransient()) continue;
            list.add(new Structure(child));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private List<Object> _getFacets(UIComponent component) {
        Iterator facetNames = component instanceof UIXComponentBase ? ((UIXComponentBase)component).getFacetNames() : component.getFacets().keySet().iterator();
        if (!facetNames.hasNext()) {
            return null;
        }
        Map facets = component.getFacets();
        ArrayList<Object> list = new ArrayList<Object>(facets.size() * 2);
        while (facetNames.hasNext()) {
            String name = (String)facetNames.next();
            UIComponent facet = (UIComponent)facets.get(name);
            if (facet == null || facet.isTransient()) continue;
            list.add(name);
            list.add(new Structure(facet));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private static String _abbreviateClass(String clazz) {
        if (clazz.startsWith(_COMMON_CLASS_PREFIX)) {
            clazz = clazz.substring(_COMMON_CLASS_PREFIX_LENGTH);
        }
        return clazz;
    }

    private static String _unabbreviateClass(String clazz) {
        if (clazz.charAt(0) == '.') {
            return _COMMON_CLASS_PREFIX + clazz;
        }
        return clazz;
    }
}

