/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputFormatted;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ValueRenderer;

public class OutputFormattedRenderer
extends ValueRenderer {
    private static final Map<String, String> _USAGES = new HashMap<String, String>();
    private PropertyKey _styleUsageKey;

    public OutputFormattedRenderer() {
        super(CoreOutputFormatted.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._styleUsageKey = type.findKey("styleUsage");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        if (this.canSkipRendering(context, rc, comp)) {
            return;
        }
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("span", comp);
        this.renderId(context, comp);
        this.renderAllAttributes(context, rc, comp, bean);
        String value = this.getConvertedString(context, comp, bean);
        this.renderFormattedText(context, value);
        rw.endElement("span");
    }

    protected String getStyleUsage(UIComponent component, FacesBean bean) {
        return OutputFormattedRenderer.toString((Object)bean.getProperty(this._styleUsageKey));
    }

    @Override
    protected String getStyleClass(UIComponent component, FacesBean bean) {
        String usage;
        String styleClass = super.getStyleClass(component, bean);
        if (styleClass == null && (usage = this.getStyleUsage(component, bean)) != null) {
            styleClass = _USAGES.get(usage);
        }
        return styleClass;
    }

    static {
        _USAGES.put("inContextBranding", "p_InContextBrandingText");
        _USAGES.put("instruction", "AFInstructionText");
        _USAGES.put("pageStamp", "OraPageStampText");
    }
}

